/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.RedisEndpoint;
import com.streamxhub.streamx.common.util.RedisEndpoint$;
import com.streamxhub.streamx.common.util.RedisNode;
import java.io.Serializable;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u00015\u00111BU3eSN\u001cuN\u001c4jO*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u000511m\\7n_:T!a\u0002\u0005\u0002\u000fM$(/Z1nq*\u0011\u0011BC\u0001\u000bgR\u0014X-Y7yQV\u0014'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011a\u0001!Q1A\u0005\u0002e\t1\"\u001b8ji&\fG\u000eS8tiV\t!\u0004\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ti!+\u001a3jg\u0016sG\r]8j]RD\u0001b\b\u0001\u0003\u0002\u0003\u0006IAG\u0001\rS:LG/[1m\u0011>\u001cH\u000f\t\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r\"\u0003CA\u000e\u0001\u0011\u0015A\u0002\u00051\u0001\u001b\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\"\u001b8ji&\fG.\u00113eeV\t\u0001\u0006\u0005\u0002*a9\u0011!F\f\t\u0003WAi\u0011\u0001\f\u0006\u0003[1\ta\u0001\u0010:p_Rt\u0014BA\u0018\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0002\u0002B\u0002\u001b\u0001A\u0003%\u0001&\u0001\u0007j]&$\u0018.\u00197BI\u0012\u0014\b\u0005C\u00047\u0001\t\u0007I\u0011A\u001c\u0002\u000b!|7\u000f^:\u0016\u0003a\u00022aD\u001d<\u0013\tQ\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cy%\u0011QH\u0001\u0002\n%\u0016$\u0017n\u001d(pI\u0016Daa\u0010\u0001!\u0002\u0013A\u0014A\u00025pgR\u001c\b\u0005C\u0004B\u0001\t\u0007I\u0011A\u001c\u0002\u000b9|G-Z:\t\r\r\u0003\u0001\u0015!\u00039\u0003\u0019qw\u000eZ3tA!)Q\t\u0001C\u0001O\u00059q-\u001a;BkRD\u0007\"B$\u0001\t\u0003A\u0015!B4fi\u0012\u0013U#A%\u0011\u0005=Q\u0015BA&\u0011\u0005\rIe\u000e\u001e\u0005\u0006\u001b\u0002!\tAT\u0001\u000eO\u0016$(+\u00198e_6tu\u000eZ3\u0016\u0003mBQ\u0001\u0015\u0001\u0005\u0002E\u000bqbZ3u\u001d>$Wm\u001d\"z'2|Go\u001d\u000b\u0004qI#\u0006\"B*P\u0001\u0004I\u0015\u0001B:Q_NDQ!V(A\u0002%\u000bA!\u001a)pg\")q\u000b\u0001C\u00011\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8G_J\\U-\u001f\u000b\u00033\u000e\u0004\"AW1\u000e\u0003mS!\u0001X/\u0002\u000b),G-[:\u000b\u0005y{\u0016aB2mS\u0016tGo\u001d\u0006\u0002A\u0006)!/\u001a3jg&\u0011!m\u0017\u0002\u0006\u0015\u0016$\u0017n\u001d\u0005\u0006IZ\u0003\r\u0001K\u0001\u0004W\u0016L\b\"\u00024\u0001\t\u00139\u0017AD2mkN$XM]#oC\ndW\r\u001a\u000b\u0003Q.\u0004\"aD5\n\u0005)\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0015\u0004\rA\u0007\u0005\u0006[\u0002!\tA\\\u0001\bO\u0016$\bj\\:u)\tYt\u000eC\u0003eY\u0002\u0007\u0001\u0006C\u0003r\u0001\u0011%!/\u0001\u0005hKRDun\u001d;t)\tA4\u000fC\u0003\u0019a\u0002\u0007!\u0004C\u0003v\u0001\u0011%a/\u0001\nhKRtuN\\\"mkN$XM\u001d(pI\u0016\u001cHC\u0001\u001dx\u0011\u0015AB\u000f1\u0001\u001b\u0011\u0015I\b\u0001\"\u0003{\u0003=9W\r^\"mkN$XM\u001d(pI\u0016\u001cHC\u0001\u001d|\u0011\u0015A\u0002\u00101\u0001\u001b\u0011\u0015i\b\u0001\"\u0001\u007f\u0003!9W\r\u001e(pI\u0016\u001cHC\u0001\u001d\u0000\u0011\u0015AB\u00101\u0001\u001b\u0001")
public class RedisConfig
implements scala.Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().db();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.nodes())).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.inter$1(sPos, ePos, node.startSlot(), node.endSlot()))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNodesBySlots$2(x$1)));
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("redis_version:"))))[0];
        String[] clusterEnable = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("cluster_enabled:")));
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return ((RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hosts())).filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHost$1(slot, host))))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHosts$1(x$4)));
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("role:slave")))) break;
            String host = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains("master_host:"))))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains("master_port:"))))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.db(), RedisEndpoint$.MODULE$.apply$default$5());
        }
        Tuple2[] slaves = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNonClusterNodes$4(x))))).map((Function1 & Serializable & scala.Serializable)rl -> {
            String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
            String ip = content[0];
            String port = content[1];
            return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slaves)).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getNonClusterNodes$6(initialHost, nodes, range, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(conn.clusterSlots()).flatMap((Function1 & Serializable & scala.Serializable)slotInfoObj -> {
            List slotInfo = (List)slotInfoObj;
            int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
            int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getClusterNodes$2(initialHost, slotInfo, sPos, ePos, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    private static final boolean inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public static final /* synthetic */ boolean $anonfun$getNodesBySlots$2(RedisNode x$1) {
        return x$1.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getHost$1(int slot$1, RedisNode host) {
        return host.startSlot() <= slot$1 && host.endSlot() >= slot$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHosts$1(RedisNode x$4) {
        return x$4.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getNonClusterNodes$4(String x) {
        return x.contains("slave") && x.contains("online");
    }

    public static final /* synthetic */ RedisNode $anonfun$getNonClusterNodes$6(RedisEndpoint initialHost$1, Tuple2[] nodes$1, int range$1, int i) {
        return new RedisNode(new RedisEndpoint((String)nodes$1[i]._1(), nodes$1[i]._2$mcI$sp(), initialHost$1.auth(), initialHost$1.db(), initialHost$1.timeout()), 0, 16383, i, range$1);
    }

    public static final /* synthetic */ RedisNode $anonfun$getClusterNodes$2(RedisEndpoint initialHost$2, List slotInfo$1, int sPos$2, int ePos$2, int i) {
        List node = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(slotInfo$1).apply(i + 2);
        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
        return new RedisNode(new RedisEndpoint(host, port, initialHost$2.auth(), initialHost$2.db(), initialHost$2.timeout()), sPos$2, ePos$2, i, slotInfo$1.size() - 2);
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

