/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.Utils$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class FileUtils$
extends FileUtils {
    public static FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public File createTempDir() {
        Object object = new Object();
        try {
            int TEMP_DIR_ATTEMPTS = 10000;
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = new StringBuilder(1).append(System.currentTimeMillis()).append("-").toString();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), TEMP_DIR_ATTEMPTS).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
                File tempDir = new File(baseDir, new StringBuilder(0).append(baseName).append(counter).toString());
                if (tempDir.mkdir()) {
                    throw new NonLocalReturnControl(object, (Object)tempDir);
                }
            });
            throw new IllegalStateException(new StringBuilder(70).append("[StreamX] Failed to create directory within ").append(TEMP_DIR_ATTEMPTS).append("  attempts (tried ").append(baseName).append(" 0 to ").append(baseName).append(" ").append(TEMP_DIR_ATTEMPTS - 1).append(")").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (File)ex.value();
        }
    }

    public void exists(String path) {
        Predef$.MODULE$.require(path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() && new File(path).exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[StreamX] FileUtils.exists: file ").append(path).append(" is not exist!").toString());
    }

    public String getPathFromEnv(String env) {
        String path = System.getenv(env);
        Predef$.MODULE$.require(Utils$.MODULE$.notEmpty(path), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("[StreamX] FileUtils.getPathFromEnv: ").append(env).append(" is not set on system env").toString());
        File file = new File(path);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("[StreamX] FileUtils.getPathFromEnv: ").append(env).append(" is not exist!").toString());
        return file.getAbsolutePath();
    }

    public String resolvePath(String parent, String child) {
        File file = new File(parent, child);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[StreamX] FileUtils.resolvePath: ").append(file.getAbsolutePath()).append(" is not exist!").toString());
        return file.getAbsolutePath();
    }

    public String getSuffix(String filename) {
        Predef$.MODULE$.require(filename != null);
        return (String)new StringOps(Predef$.MODULE$.augmentString(filename)).drop(filename.lastIndexOf("."));
    }

    public List<URL> listFileAsURL(String dirPath) {
        File[] files;
        File file = new File(dirPath);
        List<URL> list = file.exists() && file.isDirectory() ? ((files = file.listFiles()) != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).nonEmpty() ? JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> f.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList()) : Collections.emptyList()) : Collections.emptyList();
        return list;
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

