/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import scala.Function0;
import scala.Predef$;

public final class ExceptionUtils$ {
    public static ExceptionUtils$ MODULE$;
    private final String STRINGIFIED_NULL_EXCEPTION;

    static {
        new ExceptionUtils$();
    }

    public String STRINGIFIED_NULL_EXCEPTION() {
        return this.STRINGIFIED_NULL_EXCEPTION;
    }

    public String stringifyException(Throwable e) {
        String string;
        if (e == null) {
            return this.STRINGIFIED_NULL_EXCEPTION();
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            e.printStackTrace(wrt);
            wrt.close();
            string = stm.toString();
        }
        catch (Throwable throwable) {
            string = new StringBuilder(35).append(e.getClass().getName()).append(" (error while printing stack trace)").toString();
        }
        return string;
    }

    public boolean isJvmFatalError(Throwable t) {
        return t instanceof InternalError || t instanceof UnknownError || t instanceof ThreadDeath;
    }

    public boolean isJvmFatalOrOutOfMemoryError(Throwable t) {
        return this.isJvmFatalError(t) || t instanceof OutOfMemoryError;
    }

    @Nullable
    public Throwable tryEnrichOutOfMemoryError(@Nullable Throwable exception, String jvmMetaspaceOomNewErrorMessage, String jvmDirectOomNewErrorMessage) {
        boolean isOom = exception instanceof OutOfMemoryError;
        if (!isOom) {
            return exception;
        }
        OutOfMemoryError oom = (OutOfMemoryError)exception;
        if (this.isMetaspaceOutOfMemoryError(oom)) {
            return this.changeOutOfMemoryErrorMessage(oom, jvmMetaspaceOomNewErrorMessage);
        }
        if (this.isDirectOutOfMemoryError(oom)) {
            return this.changeOutOfMemoryErrorMessage(oom, jvmDirectOomNewErrorMessage);
        }
        return oom;
    }

    private OutOfMemoryError changeOutOfMemoryErrorMessage(OutOfMemoryError oom, String newMessage) {
        String string = oom.getMessage();
        String string2 = newMessage;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return oom;
        }
        OutOfMemoryError newError = new OutOfMemoryError(newMessage);
        newError.initCause(oom.getCause());
        newError.setStackTrace(oom.getStackTrace());
        return newError;
    }

    public boolean isMetaspaceOutOfMemoryError(@Nullable Throwable t) {
        return this.isOutOfMemoryErrorWithMessageStartingWith(t, "Metaspace");
    }

    public boolean isDirectOutOfMemoryError(@Nullable Throwable t) {
        return this.isOutOfMemoryErrorWithMessageStartingWith(t, "Direct buffer memory");
    }

    private boolean isOutOfMemoryErrorWithMessageStartingWith(@Nullable Throwable t, String prefix) {
        return this.isOutOfMemoryError(t) && t.getMessage() != null && t.getMessage().startsWith(prefix);
    }

    private boolean isOutOfMemoryError(@Nullable Throwable t) {
        return t != null && t.getClass() == OutOfMemoryError.class;
    }

    public void rethrowIfFatalError(Throwable t) {
        if (this.isJvmFatalError(t)) {
            throw (Error)t;
        }
    }

    public void rethrowIfFatalErrorOrOOM(Throwable t) {
        if (this.isJvmFatalError(t) || t instanceof OutOfMemoryError) {
            throw (Error)t;
        }
    }

    public <T extends Throwable> T firstOrSuppressed(T newException, @Nullable T previous) {
        T t;
        Predef$.MODULE$.require(newException != null, (Function0 & Serializable & scala.Serializable)() -> "newException");
        if (previous == null) {
            t = newException;
        } else {
            previous.addSuppressed(newException);
            t = previous;
        }
        return t;
    }

    public void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public void rethrow(Throwable t, String parentMessage) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(parentMessage, t);
    }

    public void rethrowException(Throwable t, String parentMessage) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(parentMessage, t);
    }

    public void rethrowException(Throwable t) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(t.getMessage(), t);
    }

    public void tryRethrowException(@Nullable Exception e) throws Exception {
        if (e != null) {
            throw e;
        }
    }

    public void tryRethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public void rethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    public <T extends Throwable> Optional<T> findThrowable(Throwable throwable, Class<T> searchType) {
        Optional optional;
        if (throwable == null || searchType == null) {
            optional = Optional.empty();
        } else {
            Throwable t = throwable;
            Optional<T> r = null;
            while (t != null && r == null) {
                if (searchType.isAssignableFrom(t.getClass())) {
                    r = Optional.of(searchType.cast(t));
                    continue;
                }
                t = t.getCause();
            }
            optional = r;
        }
        return optional;
    }

    public Optional<Throwable> findThrowable(Throwable throwable, Predicate<Throwable> predicate) {
        Optional<Throwable> optional;
        if (throwable == null || predicate == null) {
            optional = Optional.empty();
        } else {
            Throwable t = throwable;
            Optional<Throwable> r = null;
            while (t != null && r == null) {
                if (predicate.test(t)) {
                    r = Optional.of(t);
                    continue;
                }
                t = t.getCause();
            }
            optional = r;
        }
        return optional;
    }

    public Optional<Throwable> findThrowableWithMessage(Throwable throwable, String searchMessage) {
        Optional<Throwable> optional;
        if (throwable == null || searchMessage == null) {
            optional = Optional.empty();
        } else {
            Throwable t = throwable;
            Optional<Throwable> r = null;
            while (t != null && r == null) {
                if (t.getMessage() != null && t.getMessage().contains(searchMessage)) {
                    r = Optional.of(t);
                    continue;
                }
                t = t.getCause();
            }
            optional = r;
        }
        return optional;
    }

    public Throwable stripExecutionException(Throwable throwable) {
        return this.stripException(throwable, ExecutionException.class);
    }

    public Throwable stripCompletionException(Throwable throwable) {
        return this.stripException(throwable, CompletionException.class);
    }

    /*
     * WARNING - void declaration
     */
    public Throwable stripException(Throwable throwableToStrip, Class<? extends Throwable> typeToStrip) {
        void var3_3;
        Throwable throwable = null;
        while (typeToStrip.isAssignableFrom(throwableToStrip.getClass()) && throwableToStrip.getCause() != null) {
            throwable = throwableToStrip.getCause();
        }
        return var3_3;
    }

    public void checkInterrupted(Throwable e) {
        block0: {
            if (!(e instanceof InterruptedException)) break block0;
            Thread.currentThread().interrupt();
        }
    }

    public String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return (String[])list.toArray((Object[])ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private ExceptionUtils$() {
        MODULE$ = this;
        this.STRINGIFIED_NULL_EXCEPTION = "(null)";
    }
}

