/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.DependencyUtils;
import com.streamxhub.streamx.common.util.Utils$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DependencyUtils$ {
    public static DependencyUtils$ MODULE$;

    static {
        new DependencyUtils$();
    }

    public List<String> resolveMavenDependencies(String packagesExclusions, String packages, String repositories, String ivyRepoPath, String ivySettingsPath, Consumer<String> outCallback) throws Exception {
        Nil$ exclusions = Utils$.MODULE$.isEmpty(packagesExclusions) ? Nil$.MODULE$ : Predef$.MODULE$.wrapRefArray((Object[])packagesExclusions.split(","));
        String string = ivySettingsPath;
        IvySettings ivySettings = string == null ? this.buildIvySettings((Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath), outCallback) : this.loadIvySettings(string, (Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath), outCallback);
        IvySettings ivySettings2 = ivySettings;
        return this.resolveMavenCoordinates(packages, ivySettings2, (Seq<String>)exclusions, outCallback, this.resolveMavenCoordinates$default$5());
    }

    public Seq<DependencyUtils.MavenCoordinate> extractMavenCoordinates(String coordinates) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordinates.split(","))).map((Function1 & Serializable & scala.Serializable)p -> {
            String[] splits = p.replace("/", ":").split(":");
            Predef$.MODULE$.require(splits.length == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("[StreamX] DependencyUtils.extractMavenCoordinates: Provided Maven Coordinates must be in the form 'groupId:artifactId:version'. The coordinate provided is: ").append((String)p).toString());
            Predef$.MODULE$.require(splits[0] != null && new StringOps(Predef$.MODULE$.augmentString(splits[0].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("[StreamX] DependencyUtils.extractMavenCoordinates: The groupId cannot be null or be whitespace. The groupId provided is: ").append(splits[0]).toString());
            Predef$.MODULE$.require(splits[1] != null && new StringOps(Predef$.MODULE$.augmentString(splits[1].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("[StreamX] DependencyUtils.extractMavenCoordinates: The artifactId cannot be null or be whitespace. The artifactId provided is: ").append(splits[1]).toString());
            Predef$.MODULE$.require(splits[2] != null && new StringOps(Predef$.MODULE$.augmentString(splits[2].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("[StreamX] DependencyUtils.extractMavenCoordinates: The version cannot be null or be whitespace. The version provided is: ").append(splits[2]).toString());
            return new DependencyUtils.MavenCoordinate(splits[0], splits[1], splits[2]);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private File m2Path() {
        return new File(System.getProperty("user.home"), new StringBuilder(13).append(".m2").append(File.separator).append("repository").toString());
    }

    /*
     * WARNING - void declaration
     */
    public ChainResolver createRepoResolvers(File defaultIvyUserDir) {
        void var2_2;
        ChainResolver cr = new ChainResolver();
        cr.setName("streamx-list");
        IBiblioResolver localM2 = new IBiblioResolver();
        localM2.setM2compatible(true);
        localM2.setRoot(this.m2Path().toURI().toString());
        localM2.setUsepoms(true);
        localM2.setName("local-m2-cache");
        cr.add((DependencyResolver)localM2);
        FileSystemResolver localIvy = new FileSystemResolver();
        File localIvyRoot = new File(defaultIvyUserDir, "local");
        localIvy.setLocal(true);
        localIvy.setRepository((Repository)new FileRepository(localIvyRoot));
        String ivyPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "ivys", "ivy.xml"}))).mkString(File.separator);
        localIvy.addIvyPattern(ivyPattern);
        String artifactPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "[type]s", "[artifact](-[classifier]).[ext]"}))).mkString(File.separator);
        localIvy.addArtifactPattern(artifactPattern);
        localIvy.setName("local-ivy-cache");
        cr.add((DependencyResolver)localIvy);
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        br.setName("central");
        cr.add((DependencyResolver)br);
        return var2_2;
    }

    public List<String> resolveDependencyPaths(Object[] artifacts, File cacheDirectory) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(artifacts)).map((Function1 & Serializable & scala.Serializable)artifactInfo -> {
            ModuleRevisionId artifact = ((Artifact)artifactInfo).getModuleRevisionId();
            return new StringBuilder(6).append(cacheDirectory.getAbsolutePath()).append(File.separator).append(artifact.getOrganisation()).append("_").append(artifact.getName()).append("-").append(artifact.getRevision()).append(".jar").toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
    }

    public void addDependenciesToIvy(DefaultModuleDescriptor md, Seq<DependencyUtils.MavenCoordinate> artifacts, String ivyConfName, Consumer<String> outCallback) {
        artifacts.foreach((Function1 & Serializable & scala.Serializable)mvn -> {
            DependencyUtils$.$anonfun$addDependenciesToIvy$1(md, ivyConfName, outCallback, mvn);
            return BoxedUnit.UNIT;
        });
    }

    public void addExclusionRules(IvySettings ivySettings, String ivyConfName, DefaultModuleDescriptor md) {
        md.addExcludeRule(this.createExclusion("*:scala-library:*", ivySettings, ivyConfName));
    }

    public IvySettings buildIvySettings(Option<String> remoteRepos, Option<String> ivyPath, Consumer<String> outCallback) {
        IvySettings ivySettings = new IvySettings();
        this.processIvyPathArg(ivySettings, ivyPath);
        ivySettings.addMatcher((PatternMatcher)new GlobPatternMatcher());
        ChainResolver repoResolver = this.createRepoResolvers(ivySettings.getDefaultIvyUserDir());
        ivySettings.addResolver((DependencyResolver)repoResolver);
        ivySettings.setDefaultResolver(repoResolver.getName());
        this.processRemoteRepoArg(ivySettings, remoteRepos, outCallback);
        return ivySettings;
    }

    public IvySettings loadIvySettings(String settingsFile, Option<String> remoteRepos, Option<String> ivyPath, Consumer<String> outCallback) {
        File file = new File(settingsFile);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("[StreamX] DependencyUtils.loadIvySettings: Ivy settings file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("[StreamX] DependencyUtils.loadIvySettings: Ivy settings file ").append(file).append(" is not a normal file").toString());
        IvySettings ivySettings = new IvySettings();
        try {
            ivySettings.load(file);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof ParseException;
            if (bl) {
                throw new RuntimeException(new StringBuilder(71).append("DependencyUtils.loadIvySettings: Failed when loading Ivy settings from ").append(settingsFile).toString(), throwable2);
            }
            throw throwable;
        }
        this.processIvyPathArg(ivySettings, ivyPath);
        this.processRemoteRepoArg(ivySettings, remoteRepos, outCallback);
        return ivySettings;
    }

    private void processIvyPathArg(IvySettings ivySettings, Option<String> ivyPath) {
        ivyPath.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$processIvyPathArg$1(x$1))).foreach((Function1 & Serializable & scala.Serializable)alternateIvyDir -> {
            DependencyUtils$.$anonfun$processIvyPathArg$2(ivySettings, alternateIvyDir);
            return BoxedUnit.UNIT;
        });
    }

    private void processRemoteRepoArg(IvySettings ivySettings, Option<String> remoteRepos, Consumer<String> outCallback) {
        remoteRepos.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$processRemoteRepoArg$1(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split(",")).foreach((Function1 & Serializable & scala.Serializable)repositoryList -> {
            DependencyUtils$.$anonfun$processRemoteRepoArg$3(ivySettings, outCallback, repositoryList);
            return BoxedUnit.UNIT;
        });
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"com.streamxhub.streamx", (String)new StringBuilder(18).append("dependency-parent-").append(UUID.randomUUID().toString()).toString(), (String)"1.0"));
    }

    private void clearIvyResolutionFiles(ModuleRevisionId mdId, IvySettings ivySettings, String ivyConfName) {
        Seq currentResolutionFiles = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(ivyConfName).append(".xml").toString(), new StringBuilder(15).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".xml").toString(), new StringBuilder(22).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".properties").toString()}));
        currentResolutionFiles.foreach((Function1 & Serializable & scala.Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$clearIvyResolutionFiles$1(ivySettings, filename)));
    }

    public List<String> resolveMavenCoordinates(String coordinates, IvySettings ivySettings, Seq<String> exclusions, Consumer<String> outCallback, boolean isTest) throws Exception {
        List<String> list;
        if (Utils$.MODULE$.isEmpty(coordinates)) {
            list = List$.MODULE$.empty();
        } else {
            ResolveOptions resolveOptions;
            this.setDefaultLogger(outCallback);
            Seq<DependencyUtils.MavenCoordinate> artifacts = this.extractMavenCoordinates(coordinates);
            File packagesDirectory = new File(ivySettings.getDefaultIvyUserDir(), "jars");
            outCallback.accept(new StringBuilder(26).append("Ivy Default Cache set to: ").append(ivySettings.getDefaultCache().getAbsolutePath()).toString());
            outCallback.accept(new StringBuilder(37).append("The jars for the packages stored in: ").append(packagesDirectory).toString());
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ResolveOptions resolveOptions2 = new ResolveOptions();
            resolveOptions2.setTransitive(true);
            resolveOptions2.setOutputReport(true);
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            if (isTest) {
                resolveOptions2.setDownload(false);
                resolveOptions2.setLog("quiet");
                resolveOptions = retrieveOptions.setLog("quiet");
            } else {
                resolveOptions = resolveOptions2.setDownload(true);
            }
            String ivyConfName = "default";
            DefaultModuleDescriptor md = this.getModuleDescriptor();
            md.setDefaultConf(ivyConfName);
            this.addExclusionRules(ivySettings, ivyConfName, md);
            this.addDependenciesToIvy(md, artifacts, ivyConfName, outCallback);
            exclusions.foreach((Function1 & Serializable & scala.Serializable)e -> {
                md.addExcludeRule(DependencyUtils$.MODULE$.createExclusion(new StringBuilder(2).append(e).append(":*").toString(), ivySettings, ivyConfName));
                return BoxedUnit.UNIT;
            });
            ResolveReport rr = ivy.resolve((ModuleDescriptor)md, resolveOptions2);
            if (rr.hasError()) {
                throw new RuntimeException(rr.getAllProblemMessages().toString());
            }
            ivy.retrieve(rr.getModuleDescriptor().getModuleRevisionId(), new StringBuilder(57).append(packagesDirectory.getAbsolutePath()).append(File.separator).append("[organization]_[artifact]-[revision](-[classifier]).[ext]").toString(), retrieveOptions.setConfs((String[])((Object[])new String[]{ivyConfName})));
            List<String> paths = this.resolveDependencyPaths(rr.getArtifacts().toArray(), packagesDirectory);
            ModuleRevisionId mdId = md.getModuleRevisionId();
            this.clearIvyResolutionFiles(mdId, ivySettings, ivyConfName);
            list = paths;
        }
        return list;
    }

    public Seq<String> resolveMavenCoordinates$default$3() {
        return Nil$.MODULE$;
    }

    public boolean resolveMavenCoordinates$default$5() {
        return false;
    }

    private ExcludeRule createExclusion(String coords, IvySettings ivySettings, String ivyConfName) {
        DependencyUtils.MavenCoordinate c = (DependencyUtils.MavenCoordinate)this.extractMavenCoordinates(coords).head();
        ArtifactId id = new ArtifactId(new ModuleId(c.groupId(), c.artifactId()), "*", "*", "*");
        DefaultExcludeRule rule = new DefaultExcludeRule(id, ivySettings.getMatcher("glob"), null);
        rule.addConfiguration(ivyConfName);
        return rule;
    }

    private void setDefaultLogger(Consumer<String> outCallback) {
        Message.setDefaultLogger((MessageLogger)new DefaultMessageLogger(outCallback){
            private final Consumer outCallback$3;

            public void log(String msg, int level) {
                this.outCallback$3.accept(msg);
            }

            public void rawlog(String msg, int level) {
                this.outCallback$3.accept(msg);
            }

            public void doEndProgress(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void debug(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void verbose(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void deprecated(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void info(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void rawinfo(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void warn(String msg) {
                this.outCallback$3.accept(msg);
            }

            public void error(String msg) {
                this.outCallback$3.accept(msg);
            }
            {
                this.outCallback$3 = outCallback$3;
                super(2);
            }
        });
    }

    public static final /* synthetic */ void $anonfun$addDependenciesToIvy$1(DefaultModuleDescriptor md$1, String ivyConfName$1, Consumer outCallback$1, DependencyUtils.MavenCoordinate mvn) {
        ModuleRevisionId ri = ModuleRevisionId.newInstance((String)mvn.groupId(), (String)mvn.artifactId(), (String)mvn.version());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ri, false, false);
        dd.addDependencyConfiguration(ivyConfName$1, new StringBuilder(9).append(ivyConfName$1).append("(runtime)").toString());
        outCallback$1.accept(new StringBuilder(22).append(dd.getDependencyId()).append(" added as a dependency").toString());
        md$1.addDependency((DependencyDescriptor)dd);
    }

    public static final /* synthetic */ boolean $anonfun$processIvyPathArg$1(String x$1) {
        return x$1.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processIvyPathArg$2(IvySettings ivySettings$2, String alternateIvyDir) {
        ivySettings$2.setDefaultIvyUserDir(new File(alternateIvyDir));
        ivySettings$2.setDefaultCache(new File(alternateIvyDir, "cache"));
    }

    public static final /* synthetic */ boolean $anonfun$processRemoteRepoArg$1(String x$2) {
        return x$2.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$5(Consumer outCallback$2, ChainResolver cr$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String repo = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        IBiblioResolver brr = new IBiblioResolver();
        brr.setM2compatible(true);
        brr.setUsepoms(true);
        brr.setRoot(repo);
        brr.setName(new StringBuilder(5).append("repo-").append(i + 1).toString());
        cr$1.add((DependencyResolver)brr);
        outCallback$2.accept(new StringBuilder(45).append(repo).append(" added as a remote repository with the name: ").append(brr.getName()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$3(IvySettings ivySettings$3, Consumer outCallback$2, String[] repositoryList) {
        ChainResolver cr = new ChainResolver();
        cr.setName("user-list");
        Option$.MODULE$.apply((Object)ivySettings$3.getDefaultResolver()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            cr.add(x$1);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])repositoryList)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DependencyUtils$.$anonfun$processRemoteRepoArg$5(outCallback$2, cr, x0$1);
            return BoxedUnit.UNIT;
        });
        ivySettings$3.addResolver((DependencyResolver)cr);
        ivySettings$3.setDefaultResolver(cr.getName());
    }

    public static final /* synthetic */ boolean $anonfun$clearIvyResolutionFiles$1(IvySettings ivySettings$4, String filename) {
        return new File(ivySettings$4.getDefaultCache(), filename).delete();
    }

    private DependencyUtils$() {
        MODULE$ = this;
    }
}

