/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class DateUtils$ {
    public static DateUtils$ MODULE$;
    private final String fullFormat;
    private final String format_yyyyMMdd;
    private final String fullCompact;

    static {
        new DateUtils$();
    }

    public String fullFormat() {
        return this.fullFormat;
    }

    public String format_yyyyMMdd() {
        return this.format_yyyyMMdd;
    }

    public String fullCompact() {
        return this.fullCompact;
    }

    public Date parse(String date, String format, TimeZone timeZone) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(timeZone);
        return df.parse(date);
    }

    public String parse$default$2() {
        return this.fullFormat();
    }

    public TimeZone parse$default$3() {
        return TimeZone.getDefault();
    }

    public Date stringToDate(String date) {
        return this.parse(date, this.parse$default$2(), this.parse$default$3());
    }

    public Date milliSecond2Date(long time) {
        return new Date(time);
    }

    public Date second2Date(long time) {
        return this.milliSecond2Date(time * 1000L);
    }

    public String now(String dateFormat, TimeZone timeZone) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(timeZone);
        return df.format(new Date());
    }

    public String now$default$1() {
        return this.format_yyyyMMdd();
    }

    public TimeZone now$default$2() {
        return TimeZone.getDefault();
    }

    public int minuteOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        return calendar.get(11) * 60 + calendar.get(12);
    }

    public int minuteOf(Date date) {
        return (int)(date.getTime() / 1000L / 60L);
    }

    public Date minuteOfDay$default$1() {
        return new Date();
    }

    public TimeZone minuteOfDay$default$2() {
        return TimeZone.getDefault();
    }

    public Date minuteOf$default$1() {
        return new Date();
    }

    public int secondOf(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    public Date secondOf$default$1() {
        return new Date();
    }

    public int secondOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        return this.minuteOfDay(date, this.minuteOfDay$default$2()) * 60 + calendar.get(13);
    }

    public Date secondOfDay$default$1() {
        return new Date();
    }

    public TimeZone secondOfDay$default$2() {
        return TimeZone.getDefault();
    }

    public String format(Date date, String fmt, TimeZone timeZone) {
        String string;
        if (date == null) {
            string = null;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fmt);
            simpleDateFormat.setTimeZone(timeZone);
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    public Date format$default$1() {
        return new Date();
    }

    public String format$default$2() {
        return this.fullFormat();
    }

    public TimeZone format$default$3() {
        return TimeZone.getDefault();
    }

    public long getTime(String time, String fmt, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fmt);
        simpleDateFormat.setTimeZone(timeZone);
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> simpleDateFormat.parse(time).getTime()).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
    }

    public String getTime$default$2() {
        return this.fullFormat();
    }

    public TimeZone getTime$default$3() {
        return TimeZone.getDefault();
    }

    public Date addAndSubtract(int i, Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTime(date);
        cal.add(5, i);
        return cal.getTime();
    }

    public Date addAndSubtract$default$2() {
        return new Date();
    }

    public TimeZone addAndSubtract$default$3() {
        return TimeZone.getDefault();
    }

    public Date localToUTC(String localTime, String format) {
        Date value = new SimpleDateFormat(format).parse(localTime);
        return this.localToUTC(value);
    }

    public Date localToUTC(Date localTime) {
        long localTimeInMillis = localTime.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        return new Date(calendar.getTimeInMillis());
    }

    public String localToUTC$default$2() {
        return this.fullFormat();
    }

    public Date utcToLocal(Date utcDate) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getDefault());
        String localTime = sdf.format(BoxesRunTime.boxToLong((long)utcDate.getTime()));
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.parse(localTime);
    }

    public Date utcToLocal(String utcTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = sdf.parse(utcTime);
        return this.utcToLocal(utcDate);
    }

    public String utcToLocal$default$2() {
        return this.fullFormat();
    }

    public String toRichTimeDuration(long duration) {
        long days = TimeUnit.SECONDS.toDays(duration);
        long duration1 = duration - TimeUnit.DAYS.toSeconds(days);
        long hours = TimeUnit.SECONDS.toHours(duration1);
        long duration2 = duration1 - TimeUnit.HOURS.toSeconds(hours);
        long minutes = TimeUnit.SECONDS.toMinutes(duration2);
        long duration3 = duration2 - TimeUnit.MINUTES.toSeconds(minutes);
        long seconds = TimeUnit.SECONDS.toSeconds(duration3);
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        Object object = days != 0L ? builder.append(new StringBuilder(6).append(days).append(" days ").toString()) : BoxedUnit.UNIT;
        Object object2 = days != 0L || hours != 0L ? builder.append(new StringBuilder(7).append(hours).append(" hours ").toString()) : BoxedUnit.UNIT;
        Object object3 = days != 0L || hours != 0L || minutes != 0L ? builder.append(new StringBuilder(9).append(minutes).append(" minutes ").toString()) : BoxedUnit.UNIT;
        builder.append(new StringBuilder(8).append(seconds).append(" seconds").toString());
        return builder.toString();
    }

    public Tuple2<Object, TimeUnit> getTimeUnit(String time, Tuple2<Object, TimeUnit> tuple2) {
        Tuple2 timeUnit;
        Tuple2 tuple22;
        String string = time;
        if ("".equals(string)) {
            tuple22 = null;
        } else if (string != null) {
            TimeUnit timeUnit2;
            String string2 = string;
            int num = new StringOps(Predef$.MODULE$.augmentString(string2.replaceAll("\\s+|[a-z|A-Z]+$", ""))).toInt();
            String string3 = string2.replaceAll("^[0-9]+|\\s+", "");
            if ("".equals(string3)) {
                timeUnit2 = null;
            } else if ("s".equals(string3)) {
                timeUnit2 = TimeUnit.SECONDS;
            } else {
                boolean bl = "m".equals(string3) ? true : "min".equals(string3);
                if (bl) {
                    timeUnit2 = TimeUnit.MINUTES;
                } else if ("h".equals(string3)) {
                    timeUnit2 = TimeUnit.HOURS;
                } else {
                    boolean bl2 = "d".equals(string3) ? true : "day".equals(string3);
                    if (bl2) {
                        timeUnit2 = TimeUnit.DAYS;
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
            }
            TimeUnit unit = timeUnit2;
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)num), (Object)unit);
        } else {
            throw new MatchError((Object)string);
        }
        Tuple2 tuple23 = timeUnit = tuple22;
        Tuple2 tuple24 = tuple23 == null ? tuple2 : (tuple23._2() == null ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)(tuple23._1$mcI$sp() / 1000)), (Object)TimeUnit.SECONDS) : tuple23);
        return tuple24;
    }

    public Tuple2<Object, TimeUnit> getTimeUnit$default$2() {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)TimeUnit.SECONDS);
    }

    public String formatFullTime(LocalDateTime localDateTime) {
        return this.formatFullTime(localDateTime, this.fullFormat());
    }

    public String formatFullTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(dateTimeFormatter);
    }

    private String getDateFormat(Date date, String dateFormatType) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormatType);
        return format.format(date);
    }

    public String formatCSTTime(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Date d = sdf.parse(date);
        return this.getDateFormat(d, format);
    }

    private DateUtils$() {
        MODULE$ = this;
        this.fullFormat = "yyyy-MM-dd HH:mm:ss";
        this.format_yyyyMMdd = "yyyyMMdd";
        this.fullCompact = "yyyyMMddHHmmss";
    }
}

