/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.Logger;
import com.streamxhub.streamx.common.util.Utils$;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Supplier;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ClassLoaderUtils$
implements Logger {
    public static ClassLoaderUtils$ MODULE$;
    private final ClassLoader originalClassLoader;
    private transient org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger;
    private final String com$streamxhub$streamx$common$util$Logger$$prefix;

    static {
        new ClassLoaderUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger() {
        return this.com$streamxhub$streamx$common$util$Logger$$_logger;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String com$streamxhub$streamx$common$util$Logger$$prefix() {
        return this.com$streamxhub$streamx$common$util$Logger$$prefix;
    }

    @Override
    public final void com$streamxhub$streamx$common$util$Logger$_setter_$com$streamxhub$streamx$common$util$Logger$$prefix_$eq(String x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$prefix = x$1;
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Function0<R> func) {
        Object object;
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            object = func.apply();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        return (R)object;
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Supplier<R> supplier) {
        R r;
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            r = supplier.get();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        return r;
    }

    public void loadJar(String jarFilePath) {
        File jarFile = new File(jarFilePath);
        Predef$.MODULE$.require(jarFile.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[StreamX] ClassLoaderUtils.loadJar: jarFilePath ").append(jarFilePath).append(" is not exists").toString());
        Predef$.MODULE$.require(jarFile.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[StreamX] ClassLoaderUtils.loadJar: jarFilePath ").append(jarFilePath).append(" is not file").toString());
        this.loadPath(jarFile.getAbsolutePath(), this.loadPath$default$2());
    }

    public void loadJars(String path) {
        File jarDir = new File(path);
        Predef$.MODULE$.require(jarDir.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("[StreamX] ClassLoaderUtils.loadJars: jarPath ").append(path).append(" is not exists").toString());
        Predef$.MODULE$.require(jarDir.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[StreamX] ClassLoaderUtils.loadJars: jarPath ").append(path).append(" is not directory").toString());
        Predef$.MODULE$.require(jarDir.listFiles().length > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("[StreamX] ClassLoaderUtils.loadJars: have not jar in path:").append(path).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jarDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x -> {
            ClassLoaderUtils$.MODULE$.loadPath(x.getAbsolutePath(), ClassLoaderUtils$.MODULE$.loadPath$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void loadResource(String filepath) {
        File file = new File(filepath);
        this.addURL(file);
    }

    public void loadResourceDir(String filepath) {
        File file = new File(filepath);
        this.loopDirs(file);
    }

    private void loadPath(String filepath, List<String> ext) {
        File file = new File(filepath);
        this.loopFiles(file, ext);
    }

    private List<String> loadPath$default$2() {
        return new .colon.colon((Object)".jar", (List)new .colon.colon((Object)".zip", (List)Nil$.MODULE$));
    }

    private void loopDirs(File file2) {
        block0: {
            if (!file2.isDirectory()) break block0;
            this.addURL(file2);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                ClassLoaderUtils$.MODULE$.loopDirs(file);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void loopFiles(File file, List<String> ext) {
        block1: {
            block2: {
                block0: {
                    if (!file.isDirectory()) break block0;
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x -> {
                        ClassLoaderUtils$.MODULE$.loopFiles(x, (List<String>)ext);
                        return BoxedUnit.UNIT;
                    });
                    break block1;
                }
                if (!ext.isEmpty()) break block2;
                this.addURL(file);
                break block1;
            }
            if (!ext.exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ClassLoaderUtils$.$anonfun$loopFiles$2(file, x)))) break block1;
            Utils$.MODULE$.checkJarFile(file.toURI().toURL());
            this.addURL(file);
        }
    }

    private List<String> loopFiles$default$2() {
        return Nil$.MODULE$;
    }

    private void addURL(File file) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 instanceof URLClassLoader) {
                Method addURL2 = URLClassLoader.class.getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
                addURL2.setAccessible(true);
                object = addURL2.invoke((Object)classLoader2, file.toURI().toURL());
            } else {
                Field field = classLoader.getClass().getDeclaredField("ucp");
                field.setAccessible(true);
                Object ucp = field.get(classLoader);
                Method addURL3 = ucp.getClass().getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
                addURL3.setAccessible(true);
                object = addURL3.invoke(ucp, file.toURI().toURL());
            }
            return object;
        }).recover((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw A1;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }).get();
    }

    public static final /* synthetic */ boolean $anonfun$loopFiles$2(File file$2, String x) {
        return file$2.getName().endsWith(x);
    }

    private ClassLoaderUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }
}

