/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.Utils$;
import java.util.Collection;
import java.util.Map;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class AssertUtils$ {
    public static AssertUtils$ MODULE$;

    static {
        new AssertUtils$();
    }

    public void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public void isTrue(boolean expression) {
        this.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public void trueException(boolean expression) {
        this.trueException(expression, "[Assertion failed] - when expression is true,throw exception");
    }

    public void trueException(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public void falseException(boolean expression) {
        this.falseException(expression, "[Assertion failed] - when expression is false,throw exception");
    }

    public void falseException(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public void isNull(Object obj, String message) {
        if (obj != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void isNull(Object obj) {
        this.isNull(obj, "[Assertion failed] - the object argument must be null");
    }

    public void notNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void notNull(Seq<Object> obj) {
        this.notNull(obj, "[Assertion failed] - this argument is required; it must not be null");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), obj.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> MODULE$.notNull(obj.apply(i), new StringBuilder(77).append("[Assertion failed] - this argument index of ").append(i).append(" is required; it must not be null").toString()));
    }

    public void notNull(Object obj) {
        this.notNull(obj, "[Assertion failed] - this argument is required; it must not be null");
    }

    public void hasLength(String text, String message) {
        if (Utils$.MODULE$.isEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public void hasLength(String text) {
        this.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public void hasText(String text, String message) {
        if (Utils$.MODULE$.isEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public void hasText(String text) {
        this.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public void doesNotContain(String textToSearch, String substring, String message) {
        if (Utils$.MODULE$.notEmpty(textToSearch) && Utils$.MODULE$.notEmpty(substring) && textToSearch.indexOf(substring) != -1) {
            throw new IllegalArgumentException(message);
        }
    }

    public void doesNotContain(String textToSearch, String substring) {
        this.doesNotContain(textToSearch, substring, new StringBuilder(75).append("[Assertion failed] - this String argument must not contain the substring [").append(substring).append("]").toString());
    }

    public void notEmpty(Object[] array, String message) {
        if (Utils$.MODULE$.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public void notEmpty(Object[] array) {
        this.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public void noNullElements(Object[] array, String message) {
        block0: {
            if (array == null) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(array)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                if (array[i] == null) {
                    throw new IllegalArgumentException(message);
                }
            });
        }
    }

    public void noNullElements(Object[] array) {
        this.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public void notEmpty(Collection<?> collection, String message) {
        if (Utils$.MODULE$.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public void notEmpty(Collection<?> collection) {
        this.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public void notEmpty(Map<?, ?> map, String message) {
        if (Utils$.MODULE$.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public void notEmpty(Map<?, ?> map) {
        this.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public void isAssignable(Class<?> superType, Class<?> subType) {
        this.isAssignable(superType, subType, "");
    }

    public void isAssignable(Class<?> superType, Class<?> subType, String message) {
        this.notNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(new StringBuilder(22).append(message).append(subType).append(" is not assignable to ").append(superType).toString());
        }
    }

    public void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public void state(boolean expression) {
        this.state(expression, "[Assertion failed] - this state invariant must be true");
    }

    public <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    private AssertUtils$() {
        MODULE$ = this;
    }
}

