/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.domain;

import com.streamxhub.streamx.common.util.AssertUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.IntStream;

public class FlinkMemorySize
implements Serializable,
Comparable<FlinkMemorySize> {
    private static final long serialVersionUID = 1L;
    public static final FlinkMemorySize ZERO = new FlinkMemorySize(0L);
    public static final FlinkMemorySize MAX_VALUE = new FlinkMemorySize(Long.MAX_VALUE);
    private static final List<MemoryUnit> ORDERED_UNITS = Arrays.asList(MemoryUnit.BYTES, MemoryUnit.KILO_BYTES, MemoryUnit.MEGA_BYTES, MemoryUnit.GIGA_BYTES, MemoryUnit.TERA_BYTES);
    private final long bytes;
    private transient String stringified;
    private transient String humanReadableStr;

    public FlinkMemorySize(long bytes) {
        AssertUtils.checkArgument(bytes >= 0L, "bytes must be >= 0");
        this.bytes = bytes;
    }

    public static FlinkMemorySize ofMebiBytes(long mebiBytes) {
        return new FlinkMemorySize(mebiBytes << 20);
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getKibiBytes() {
        return this.bytes >> 10;
    }

    public int getMebiBytes() {
        return (int)(this.bytes >> 20);
    }

    public long getGibiBytes() {
        return this.bytes >> 30;
    }

    public long getTebiBytes() {
        return this.bytes >> 40;
    }

    public int hashCode() {
        return (int)(this.bytes ^ this.bytes >>> 32);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && ((FlinkMemorySize)obj).bytes == this.bytes;
    }

    public String toString() {
        if (this.stringified == null) {
            this.stringified = this.formatToString();
        }
        return this.stringified;
    }

    private String formatToString() {
        MemoryUnit highestIntegerUnit = IntStream.range(0, ORDERED_UNITS.size()).sequential().filter(idx -> this.bytes % ORDERED_UNITS.get(idx).getMultiplier() != 0L).boxed().findFirst().map(idx -> {
            if (idx == 0) {
                return ORDERED_UNITS.get(0);
            }
            return ORDERED_UNITS.get(idx - 1);
        }).orElse(MemoryUnit.BYTES);
        return String.format("%d %s", this.bytes / highestIntegerUnit.getMultiplier(), highestIntegerUnit.getUnits()[1]);
    }

    public String toHumanReadableString() {
        if (this.humanReadableStr == null) {
            this.humanReadableStr = this.formatToHumanReadableString();
        }
        return this.humanReadableStr;
    }

    private String formatToHumanReadableString() {
        MemoryUnit highestUnit = IntStream.range(0, ORDERED_UNITS.size()).sequential().filter(idx -> this.bytes > ORDERED_UNITS.get(idx).getMultiplier()).boxed().max(Comparator.naturalOrder()).map(ORDERED_UNITS::get).orElse(MemoryUnit.BYTES);
        if (highestUnit == MemoryUnit.BYTES) {
            return String.format("%d %s", this.bytes, MemoryUnit.BYTES.getUnits()[1]);
        }
        double approximate = 1.0 * (double)this.bytes / (double)highestUnit.getMultiplier();
        return String.format(Locale.ROOT, "%.3f%s (%d bytes)", approximate, highestUnit.getUnits()[1], this.bytes);
    }

    @Override
    public int compareTo(FlinkMemorySize that) {
        return Long.compare(this.bytes, that.bytes);
    }

    public FlinkMemorySize add(FlinkMemorySize that) {
        return new FlinkMemorySize(Math.addExact(this.bytes, that.bytes));
    }

    public FlinkMemorySize subtract(FlinkMemorySize that) {
        return new FlinkMemorySize(Math.subtractExact(this.bytes, that.bytes));
    }

    public FlinkMemorySize multiply(double multiplier) {
        AssertUtils.checkArgument(multiplier >= 0.0, "multiplier must be >= 0");
        BigDecimal product = BigDecimal.valueOf(this.bytes).multiply(BigDecimal.valueOf(multiplier));
        if (product.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
            throw new ArithmeticException("long overflow");
        }
        return new FlinkMemorySize(product.longValue());
    }

    public FlinkMemorySize divide(long by) {
        AssertUtils.checkArgument(by >= 0L, "divisor must be >= 0");
        return new FlinkMemorySize(this.bytes / by);
    }

    public static FlinkMemorySize parse(String text) throws IllegalArgumentException {
        return new FlinkMemorySize(FlinkMemorySize.parseBytes(text));
    }

    public static FlinkMemorySize parse(String text, MemoryUnit defaultUnit) throws IllegalArgumentException {
        if (!MemoryUnit.hasUnit(text)) {
            return FlinkMemorySize.parse(text + defaultUnit.getUnits()[0]);
        }
        return FlinkMemorySize.parse(text);
    }

    public static long parseBytes(String text) throws IllegalArgumentException {
        long value;
        char current;
        int pos;
        AssertUtils.checkNotNull(text, "text");
        String trimmed = text.trim();
        AssertUtils.checkArgument(!trimmed.isEmpty(), "argument is an empty- or whitespace-only string");
        int len = trimmed.length();
        for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
        }
        String number = trimmed.substring(0, pos);
        String unit = trimmed.substring(pos).trim().toLowerCase(Locale.US);
        if (number.isEmpty()) {
            throw new NumberFormatException("text does not start with a number");
        }
        try {
            value = Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value '" + number + "' cannot be re represented as 64bit number (numeric overflow).");
        }
        long multiplier = FlinkMemorySize.parseUnit(unit).map(MemoryUnit::getMultiplier).orElse(1L);
        long result = value * multiplier;
        if (result / multiplier != value) {
            throw new IllegalArgumentException("The value '" + text + "' cannot be re represented as 64bit number of bytes (numeric overflow).");
        }
        return result;
    }

    private static Optional<MemoryUnit> parseUnit(String unit) {
        if (FlinkMemorySize.matchesAny(unit, MemoryUnit.BYTES)) {
            return Optional.of(MemoryUnit.BYTES);
        }
        if (FlinkMemorySize.matchesAny(unit, MemoryUnit.KILO_BYTES)) {
            return Optional.of(MemoryUnit.KILO_BYTES);
        }
        if (FlinkMemorySize.matchesAny(unit, MemoryUnit.MEGA_BYTES)) {
            return Optional.of(MemoryUnit.MEGA_BYTES);
        }
        if (FlinkMemorySize.matchesAny(unit, MemoryUnit.GIGA_BYTES)) {
            return Optional.of(MemoryUnit.GIGA_BYTES);
        }
        if (FlinkMemorySize.matchesAny(unit, MemoryUnit.TERA_BYTES)) {
            return Optional.of(MemoryUnit.TERA_BYTES);
        }
        if (!unit.isEmpty()) {
            throw new IllegalArgumentException("Memory size unit '" + unit + "' does not match any of the recognized units: " + MemoryUnit.getAllUnits());
        }
        return Optional.empty();
    }

    private static boolean matchesAny(String str, MemoryUnit unit) {
        for (String s : unit.getUnits()) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static enum MemoryUnit {
        BYTES(new String[]{"b", "bytes"}, 1L),
        KILO_BYTES(new String[]{"k", "kb", "kibibytes"}, 1024L),
        MEGA_BYTES(new String[]{"m", "mb", "mebibytes"}, 0x100000L),
        GIGA_BYTES(new String[]{"g", "gb", "gibibytes"}, 0x40000000L),
        TERA_BYTES(new String[]{"t", "tb", "tebibytes"}, 0x10000000000L);

        private final String[] units;
        private final long multiplier;

        private MemoryUnit(String[] units, long multiplier) {
            this.units = units;
            this.multiplier = multiplier;
        }

        public String[] getUnits() {
            return this.units;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public static String getAllUnits() {
            return MemoryUnit.concatenateUnits(BYTES.getUnits(), KILO_BYTES.getUnits(), MEGA_BYTES.getUnits(), GIGA_BYTES.getUnits(), TERA_BYTES.getUnits());
        }

        public static boolean hasUnit(String text) {
            char current;
            int pos;
            AssertUtils.checkNotNull(text, "text");
            String trimmed = text.trim();
            AssertUtils.checkArgument(!trimmed.isEmpty(), "argument is an empty- or whitespace-only string");
            int len = trimmed.length();
            for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
            }
            String unit = trimmed.substring(pos).trim().toLowerCase(Locale.US);
            return unit.length() > 0;
        }

        private static String concatenateUnits(String[] ... allUnits) {
            StringBuilder builder = new StringBuilder(128);
            for (String[] units : allUnits) {
                builder.append('(');
                for (String unit : units) {
                    builder.append(unit);
                    builder.append(" | ");
                }
                builder.setLength(builder.length() - 3);
                builder.append(") / ");
            }
            builder.setLength(builder.length() - 3);
            return builder.toString();
        }
    }
}

