/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.NameFactory;
import java.lang.annotation.ElementType;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\u001a9\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005\u001a\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005\u001a\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0005\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u001a\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a8\u0006!"}, d2={"annotationName", "T", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "extension", "Lcom/squareup/wire/schema/Field;", "factory", "Lcom/squareup/wire/schema/internal/NameFactory;", "simpleNameSuffix", "", "(Lcom/squareup/wire/schema/ProtoFile;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/internal/NameFactory;Ljava/lang/String;)Ljava/lang/Object;", "annotationTargetType", "Ljava/lang/annotation/ElementType;", "extend", "Lcom/squareup/wire/schema/Extend;", "builtInAdapterString", "type", "Lcom/squareup/wire/schema/ProtoType;", "useArray", "", "eligibleAsAnnotationMember", "schema", "Lcom/squareup/wire/schema/Schema;", "field", "hasEponymousType", "javaPackage", "legacyQualifiedFieldName", "optionValueToInt", "", "value", "", "optionValueToLong", "", "wire-schema"})
@JvmName(name="JvmLanguages")
public final class JvmLanguages {
    @JvmOverloads
    @Nullable
    public static final String builtInAdapterString(@NotNull ProtoType type, boolean useArray) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isScalar()) {
            if (useArray) {
                String string;
                ProtoType protoType = type;
                if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT32)) {
                    string = ProtoAdapter.class.getName() + "#INT32_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT32)) {
                    string = ProtoAdapter.class.getName() + "#UINT32_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.SINT32)) {
                    string = ProtoAdapter.class.getName() + "#SINT32_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.FIXED32)) {
                    string = ProtoAdapter.class.getName() + "#FIXED32_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.SFIXED32)) {
                    string = ProtoAdapter.class.getName() + "#SFIXED32_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT64)) {
                    string = ProtoAdapter.class.getName() + "#INT64_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT64)) {
                    string = ProtoAdapter.class.getName() + "#UINT64_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.SINT64)) {
                    string = ProtoAdapter.class.getName() + "#SINT64_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.FIXED64)) {
                    string = ProtoAdapter.class.getName() + "#FIXED64_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.SFIXED64)) {
                    string = ProtoAdapter.class.getName() + "#SFIXED64_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.FLOAT)) {
                    string = ProtoAdapter.class.getName() + "#FLOAT_ARRAY";
                } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DOUBLE)) {
                    string = ProtoAdapter.class.getName() + "#DOUBLE_ARRAY";
                } else {
                    throw new IllegalArgumentException("No Array adapter for " + type);
                }
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder().append(ProtoAdapter.class.getName()).append('#');
            String string = type.toString();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return stringBuilder.append(string2).toString();
        }
        ProtoType protoType = type;
        return Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DURATION) ? ProtoAdapter.class.getName() + "#DURATION" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.TIMESTAMP) ? ProtoAdapter.class.getName() + "#INSTANT" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.EMPTY) ? ProtoAdapter.class.getName() + "#EMPTY" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_MAP) ? ProtoAdapter.class.getName() + "#STRUCT_MAP" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_VALUE) ? ProtoAdapter.class.getName() + "#STRUCT_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_NULL) ? ProtoAdapter.class.getName() + "#STRUCT_NULL" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_LIST) ? ProtoAdapter.class.getName() + "#STRUCT_LIST" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DOUBLE_VALUE) ? ProtoAdapter.class.getName() + "#DOUBLE_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.FLOAT_VALUE) ? ProtoAdapter.class.getName() + "#FLOAT_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT64_VALUE) ? ProtoAdapter.class.getName() + "#INT64_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT64_VALUE) ? ProtoAdapter.class.getName() + "#UINT64_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT32_VALUE) ? ProtoAdapter.class.getName() + "#INT32_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT32_VALUE) ? ProtoAdapter.class.getName() + "#UINT32_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BOOL_VALUE) ? ProtoAdapter.class.getName() + "#BOOL_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRING_VALUE) ? ProtoAdapter.class.getName() + "#STRING_VALUE" : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BYTES_VALUE) ? ProtoAdapter.class.getName() + "#BYTES_VALUE" : null)))))))))))))));
    }

    public static /* synthetic */ String builtInAdapterString$default(ProtoType protoType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return JvmLanguages.builtInAdapterString(protoType, bl);
    }

    public static final boolean eligibleAsAnnotationMember(@NotNull Schema schema, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ProtoType protoType = field.getType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType type = protoType;
        if (Intrinsics.areEqual((Object)type, (Object)ProtoType.BYTES)) {
            return false;
        }
        if (!type.isScalar() && !(schema.getType(type) instanceof EnumType)) {
            return false;
        }
        String qualifiedName = field.getQualifiedName();
        if (StringsKt.startsWith$default((String)qualifiedName, (String)"google.protobuf.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"wire.", (boolean)false, (int)2, null)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)field.getName(), (Object)"redacted");
    }

    @Nullable
    public static final ElementType annotationTargetType(@NotNull Extend extend) {
        Intrinsics.checkNotNullParameter((Object)extend, (String)"extend");
        ProtoType protoType = extend.getType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType protoType2 = protoType;
        return ((Intrinsics.areEqual((Object)protoType2, (Object)Options.MESSAGE_OPTIONS) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.ENUM_OPTIONS)) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.SERVICE_OPTIONS)) ? ElementType.TYPE : ((Intrinsics.areEqual((Object)protoType2, (Object)Options.FIELD_OPTIONS) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.ENUM_VALUE_OPTIONS)) ? ElementType.FIELD : (Intrinsics.areEqual((Object)protoType2, (Object)Options.METHOD_OPTIONS) ? ElementType.METHOD : null));
    }

    public static final int optionValueToInt(@Nullable Object value) {
        int n;
        if (value == null) {
            return 0;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default((String)string, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"0X", (boolean)false, (int)2, null)) {
            String string2 = string.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            n = Integer.parseInt(string2, CharsKt.checkRadix((int)16));
        } else {
            if (StringsKt.startsWith$default((String)string, (String)"0", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)string, (Object)"0")) {
                throw new IllegalStateException(("Octal literal unsupported: " + value).toString());
            }
            n = new BigInteger(string).intValue();
        }
        return n;
    }

    public static final long optionValueToLong(@Nullable Object value) {
        long l;
        if (value == null) {
            return 0L;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default((String)string, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"0X", (boolean)false, (int)2, null)) {
            String string2 = string.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            l = Long.parseLong(string2, CharsKt.checkRadix((int)16));
        } else {
            if (StringsKt.startsWith$default((String)string, (String)"0", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)string, (Object)"0")) {
                throw new IllegalStateException(("Octal literal unsupported: " + value).toString());
            }
            l = new BigInteger(string).longValue();
        }
        return l;
    }

    @NotNull
    public static final String javaPackage(@NotNull ProtoFile protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        String wirePackage = protoFile.wirePackage();
        if (wirePackage != null) {
            return wirePackage;
        }
        String javaPackage = protoFile.javaPackage();
        if (javaPackage != null) {
            return javaPackage;
        }
        String string = protoFile.getPackageName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static final boolean hasEponymousType(@NotNull Schema schema, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return schema.getType(JvmLanguages.legacyQualifiedFieldName(field)) != null;
    }

    @NotNull
    public static final String legacyQualifiedFieldName(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return StringsKt.isBlank((CharSequence)field.getPackageName()) ? field.getName() : field.getPackageName() + '.' + field.getName();
    }

    public static final <T> T annotationName(@NotNull ProtoFile protoFile, @NotNull Field extension, @NotNull NameFactory<T> factory, @NotNull String simpleNameSuffix) {
        List list;
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)simpleNameSuffix, (String)"simpleNameSuffix");
        String simpleName = _PlatformKt.camelCase((String)extension.getName(), (boolean)true) + simpleNameSuffix;
        switch (extension.getNamespaces().size()) {
            case 0: 
            case 1: {
                list = CollectionsKt.listOf((Object)simpleName);
                break;
            }
            default: {
                list = CollectionsKt.plus((Collection)extension.getNamespaces().subList(1, extension.getNamespaces().size()), (Object)simpleName);
            }
        }
        List names = list;
        Object type = null;
        for (String n : names) {
            type = type == null ? factory.newName(JvmLanguages.javaPackage(protoFile), n) : factory.nestedName(type, n);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        return type;
    }

    public static /* synthetic */ Object annotationName$default(ProtoFile protoFile, Field field, NameFactory nameFactory, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = "Option";
        }
        return JvmLanguages.annotationName(protoFile, field, nameFactory, string);
    }

    @JvmOverloads
    @Nullable
    public static final String builtInAdapterString(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return JvmLanguages.builtInAdapterString$default(type, false, 2, null);
    }
}

