/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.internal.JsonFormatter;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/DurationJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Ljava/time/Duration;", "Lcom/squareup/wire/Duration;", "()V", "fromString", "value", "", "toStringOrNumber", "wire-runtime"})
public final class DurationJsonFormatter
implements JsonFormatter<Duration> {
    @NotNull
    public static final DurationJsonFormatter INSTANCE = new DurationJsonFormatter();

    private DurationJsonFormatter() {
    }

    @NotNull
    public String toStringOrNumber(@NotNull Duration value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long seconds = value.getSeconds();
        int nanos = value.getNano();
        String prefix = "";
        if (seconds < 0L) {
            if (seconds == Long.MIN_VALUE) {
                prefix = "-922337203685477580";
                seconds = 8L;
            } else {
                prefix = "-";
                seconds = -seconds;
            }
            if (nanos != 0) {
                --seconds;
                nanos = 1000000000 - nanos;
            }
        }
        if (nanos == 0) {
            String string2 = "%s%ds";
            Object[] objectArray = new Object[]{prefix, seconds};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        } else if (nanos % 1000000 == 0) {
            String string4 = "%s%d.%03ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000000L};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
        } else if (nanos % 1000 == 0) {
            String string6 = "%s%d.%06ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000L};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(this, *args)");
        } else {
            String string8 = "%s%d.%09ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1L};
            boolean bl = false;
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"java.lang.String.format(this, *args)");
        }
        return string;
    }

    @Override
    @NotNull
    public Duration fromString(@NotNull String value) {
        int i;
        int nanosDigits;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int sIndex = StringsKt.indexOf$default((CharSequence)value, (char)'s', (int)0, (boolean)false, (int)6, null);
        if (sIndex != value.length() - 1) {
            throw new NumberFormatException();
        }
        int dotIndex = StringsKt.indexOf$default((CharSequence)value, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex == -1) {
            Object object = value;
            int n = 0;
            boolean bl = false;
            String string = ((String)object).substring(n, sIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = string;
            n = 0;
            long seconds = Long.parseLong((String)object);
            object = Duration.ofSeconds(seconds);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofSeconds(seconds)");
            return object;
        }
        String string = value;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, dotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string2;
        n = 0;
        long seconds = Long.parseLong(string);
        String string3 = value;
        int n2 = dotIndex + 1;
        boolean bl2 = false;
        String string4 = string3.substring(n2, sIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string3 = string4;
        n2 = 0;
        long nanos = Long.parseLong(string3);
        if (StringsKt.startsWith$default((String)value, (String)"-", (boolean)false, (int)2, null)) {
            nanos = -nanos;
        }
        if ((n2 = (nanosDigits = sIndex - (dotIndex + 1))) < 9) {
            do {
                i = n2++;
                nanos *= (long)10;
            } while (n2 < 9);
        }
        if ((n2 = 9) < nanosDigits) {
            do {
                i = n2++;
                nanos /= (long)10;
            } while (n2 < nanosDigits);
        }
        Duration duration = Duration.ofSeconds(seconds, nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(seconds, nanos)");
        return duration;
    }
}

