/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockResponse;
import mockwebserver3.MockResponseBody;
import mockwebserver3.MockWebServer;
import mockwebserver3.PushPromise;
import mockwebserver3.QueueDispatcher;
import mockwebserver3.RecordedRequest;
import mockwebserver3.SocketEffect;
import mockwebserver3.internal.MockWebServerSocket;
import mockwebserver3.internal.RecordedRequestFactoryKt;
import mockwebserver3.internal.RequestLine;
import mockwebserver3.internal.ThrottledSink;
import mockwebserver3.internal.TriggerSink;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.BufferedSocket;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Socket;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0089\u00012\u00020\u0001:\b\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020;J\u000e\u0010S\u001a\u00020T2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010U\u001a\u00020TJ\u0006\u0010V\u001a\u00020TJ\u0006\u0010W\u001a\u00020TJ\u0006\u0010X\u001a\u00020\nJ\u0018\u0010X\u001a\u0004\u0018\u00010\n2\u0006\u0010Y\u001a\u00020$2\u0006\u0010Z\u001a\u00020[J\u000e\u0010\\\u001a\u00020T2\u0006\u0010]\u001a\u00020^J\u0012\u0010_\u001a\u00020T2\b\b\u0002\u00108\u001a\u00020\u001dH\u0007J\u0016\u0010_\u001a\u00020T2\u0006\u0010`\u001a\u00020a2\u0006\u00108\u001a\u00020\u001dJ\u0010\u0010_\u001a\u00020T2\u0006\u00105\u001a\u00020\u0019H\u0002J\b\u0010b\u001a\u00020TH\u0002J\b\u0010c\u001a\u00020TH\u0016J \u0010d\u001a\u00020T2\u0006\u0010e\u001a\u00020\u001d2\u0006\u0010f\u001a\u00020\r2\u0006\u0010g\u001a\u00020^H\u0002J\u0010\u0010h\u001a\u00020T2\u0006\u0010f\u001a\u00020\rH\u0002J*\u0010i\u001a\u00020T2\u0006\u0010e\u001a\u00020\u001d2\u0006\u0010j\u001a\u00020\u001d2\u0006\u0010k\u001a\u00020l2\b\b\u0002\u0010m\u001a\u00020nH\u0002J \u0010o\u001a\u00020\n2\u0006\u0010k\u001a\u00020l2\u0006\u0010e\u001a\u00020\u001d2\u0006\u0010j\u001a\u00020\u001dH\u0002J \u0010p\u001a\u00020T2\u0006\u0010k\u001a\u00020l2\u0006\u0010q\u001a\u00020\n2\u0006\u0010]\u001a\u00020^H\u0002J\u0018\u0010r\u001a\u00020T2\u0006\u0010k\u001a\u00020l2\u0006\u0010]\u001a\u00020^H\u0002J\u0018\u0010s\u001a\u00020T2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020wH\u0002J:\u0010x\u001a\u00020y*\u00020y2\u0006\u0010z\u001a\u00020^2\b\u0010{\u001a\u0004\u0018\u00010|2\u0006\u0010}\u001a\u00020$2\u0006\u0010k\u001a\u00020l2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010\u007fH\u0002J(\u0010\u0080\u0001\u001a\u00020\u001f2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010|2\u0006\u0010k\u001a\u00020l2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010\u007fH\u0002J\u0013\u0010\u0082\u0001\u001a\u00020T2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\t\u0010\u0085\u0001\u001a\u00020;H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00110\u0011 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R(\u0010*\u001a\u0004\u0018\u00010\u00152\b\u0010)\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\"R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR0\u0010I\u001a\b\u0012\u0004\u0012\u00020H0G2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020H0G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u0011\u0010N\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010D\u00a8\u0006\u008a\u0001"}, d2={"Lmockwebserver3/MockWebServer;", "Ljava/io/Closeable;", "<init>", "()V", "taskRunnerBackend", "Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lmockwebserver3/RecordedRequest;", "openClientSockets", "", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "", "openConnections", "Lokhttp3/internal/http2/Http2Connection;", "atomicRequestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "serverSocketFactory_", "Ljavax/net/ServerSocketFactory;", "serverSocket", "Ljava/net/ServerSocket;", "socketAddress_", "Ljava/net/InetSocketAddress;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "clientAuth", "", "closed", "", "requestCount", "getRequestCount", "()I", "bodyLimit", "", "getBodyLimit", "()J", "setBodyLimit", "(J)V", "value", "serverSocketFactory", "getServerSocketFactory", "()Ljavax/net/ServerSocketFactory;", "setServerSocketFactory", "(Ljavax/net/ServerSocketFactory;)V", "dispatcher", "Lmockwebserver3/Dispatcher;", "getDispatcher", "()Lmockwebserver3/Dispatcher;", "setDispatcher", "(Lmockwebserver3/Dispatcher;)V", "socketAddress", "getSocketAddress", "()Ljava/net/InetSocketAddress;", "port", "getPort", "hostName", "", "getHostName", "()Ljava/lang/String;", "proxyAddress", "Ljava/net/Proxy;", "getProxyAddress", "()Ljava/net/Proxy;", "protocolNegotiationEnabled", "getProtocolNegotiationEnabled", "()Z", "setProtocolNegotiationEnabled", "(Z)V", "", "Lokhttp3/Protocol;", "protocols", "getProtocols", "()Ljava/util/List;", "setProtocols", "(Ljava/util/List;)V", "started", "getStarted", "url", "Lokhttp3/HttpUrl;", "path", "useHttps", "", "noClientAuth", "requestClientAuth", "requireClientAuth", "takeRequest", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "enqueue", "response", "Lmockwebserver3/MockResponse;", "start", "inetAddress", "Ljava/net/InetAddress;", "acceptConnections", "close", "serveConnection", "connectionIndex", "raw", "firstExchangePeek", "processHandshakeFailure", "dispatchBookkeepingRequest", "exchangeIndex", "socket", "Lmockwebserver3/internal/MockWebServerSocket;", "requestLine", "Lmockwebserver3/internal/RequestLine;", "readRequest", "handleWebSocketUpgrade", "request", "writeHttpResponse", "writeHeaders", "sink", "Lokio/BufferedSink;", "headers", "Lokhttp3/Headers;", "withThrottlingAndSocketEffect", "Lokio/Sink;", "policy", "socketEffect", "Lmockwebserver3/SocketEffect;", "expectedByteCount", "stream", "Lokhttp3/internal/http2/Http2Stream;", "handleSocketEffect", "effect", "readEmptyLine", "source", "Lokio/BufferedSource;", "toString", "SocketHandler", "TruncatingBuffer", "Http2SocketHandler", "Companion", "mockwebserver3"})
@SourceDebugExtension(value={"SMAP\nMockWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServer.kt\nmockwebserver3/MockWebServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1294:1\n1#2:1295\n*E\n"})
public final class MockWebServer
implements Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner.RealBackend taskRunnerBackend = new TaskRunner.RealBackend(_UtilJvmKt.threadFactory((String)"MockWebServer TaskRunner", (boolean)false));
    @NotNull
    private final TaskRunner taskRunner = new TaskRunner((TaskRunner.Backend)this.taskRunnerBackend, null, 2, null);
    @NotNull
    private final LinkedBlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue();
    private final Set<java.net.Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final AtomicInteger atomicRequestCount = new AtomicInteger();
    @Nullable
    private ServerSocketFactory serverSocketFactory_;
    @Nullable
    private ServerSocket serverSocket;
    @Nullable
    private InetSocketAddress socketAddress_;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    private int clientAuth;
    private boolean closed;
    private long bodyLimit = Long.MAX_VALUE;
    @NotNull
    private Dispatcher dispatcher = new QueueDispatcher();
    private boolean protocolNegotiationEnabled = true;
    @NotNull
    private List<? extends Protocol> protocols;
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    @NotNull
    private static final Companion.UNTRUSTED_TRUST_MANAGER.1 UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

        public Void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            throw new CertificateException();
        }

        public Void checkServerTrusted(X509Certificate[] chain, String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            throw new AssertionError();
        }

        public X509Certificate[] getAcceptedIssuers() {
            throw new AssertionError();
        }
    };
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());

    public MockWebServer() {
        Object[] objectArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        this.protocols = _UtilJvmKt.immutableListOf((Object[])objectArray);
    }

    public final int getRequestCount() {
        return this.atomicRequestCount.get();
    }

    public final long getBodyLimit() {
        return this.bodyLimit;
    }

    public final void setBodyLimit(long l) {
        this.bodyLimit = l;
    }

    @Nullable
    public final synchronized ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory_;
    }

    public final synchronized void setServerSocketFactory(@Nullable ServerSocketFactory value) {
        if (!(this.socketAddress_ == null)) {
            boolean bl = false;
            String string = "serverSocketFactory must not be set after start()";
            throw new IllegalStateException(string.toString());
        }
        this.serverSocketFactory_ = value;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    @NotNull
    public final InetSocketAddress getSocketAddress() {
        InetSocketAddress inetSocketAddress = this.socketAddress_;
        if (inetSocketAddress == null) {
            throw new IllegalStateException("call start() first".toString());
        }
        return inetSocketAddress;
    }

    public final int getPort() {
        return this.getSocketAddress().getPort();
    }

    @NotNull
    public final String getHostName() {
        String string = this.getSocketAddress().getAddress().getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
        return string;
    }

    @NotNull
    public final Proxy getProxyAddress() {
        return new Proxy(Proxy.Type.HTTP, this.getSocketAddress());
    }

    public final boolean getProtocolNegotiationEnabled() {
        return this.protocolNegotiationEnabled;
    }

    public final void setProtocolNegotiationEnabled(boolean bl) {
        this.protocolNegotiationEnabled = bl;
    }

    @NotNull
    public final List<Protocol> getProtocols() {
        return this.protocols;
    }

    public final void setProtocols(@NotNull List<? extends Protocol> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List protocolList = _UtilJvmKt.toImmutableList(value);
        if (!(!protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE) || protocolList.size() == 1)) {
            boolean $i$a$-require-MockWebServer$protocols$42 = false;
            String $i$a$-require-MockWebServer$protocols$42 = "protocols containing h2_prior_knowledge cannot use other protocols: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$42.toString());
        }
        if (!(protocolList.contains(Protocol.HTTP_1_1) || protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE))) {
            boolean $i$a$-require-MockWebServer$protocols$52 = false;
            String $i$a$-require-MockWebServer$protocols$52 = "protocols doesn't contain http/1.1: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$52.toString());
        }
        Intrinsics.checkNotNull((Object)protocolList, (String)"null cannot be cast to non-null type kotlin.collections.List<okhttp3.Protocol?>");
        if (!(!protocolList.contains(null))) {
            boolean bl = false;
            String string = "protocols must not contain null";
            throw new IllegalArgumentException(string.toString());
        }
        this.protocols = protocolList;
    }

    public final boolean getStarted() {
        return this.socketAddress_ != null;
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
        Intrinsics.checkNotNull((Object)httpUrl);
        return httpUrl;
    }

    public final void useHttps(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
    }

    public final void noClientAuth() {
        this.clientAuth = 0;
    }

    public final void requestClientAuth() {
        this.clientAuth = 1;
    }

    public final void requireClientAuth() {
        this.clientAuth = 2;
    }

    @NotNull
    public final RecordedRequest takeRequest() throws InterruptedException {
        RecordedRequest recordedRequest = this.requestQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)recordedRequest, (String)"take(...)");
        return recordedRequest;
    }

    @Nullable
    public final RecordedRequest takeRequest(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.requestQueue.poll(timeout, unit);
    }

    public final void enqueue(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Dispatcher dispatcher = this.dispatcher;
        Intrinsics.checkNotNull((Object)dispatcher, (String)"null cannot be cast to non-null type mockwebserver3.QueueDispatcher");
        ((QueueDispatcher)dispatcher).enqueue(response);
    }

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockWebServer mockWebServer, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockWebServer.start(n);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        this.start(new InetSocketAddress(inetAddress, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void start(InetSocketAddress socketAddress) throws IOException {
        if (!(!this.closed)) {
            boolean $i$a$-check-MockWebServer$start$42 = false;
            String $i$a$-check-MockWebServer$start$42 = "close() already called";
            throw new IllegalStateException($i$a$-check-MockWebServer$start$42.toString());
        }
        InetSocketAddress alreadyStartedAddress = this.socketAddress_;
        if (alreadyStartedAddress != null) {
            if (!Intrinsics.areEqual((Object)socketAddress.getAddress(), (Object)alreadyStartedAddress.getAddress())) {
                boolean $i$a$-check-MockWebServer$start$52 = false;
                String $i$a$-check-MockWebServer$start$52 = "unexpected address";
                throw new IllegalStateException($i$a$-check-MockWebServer$start$52.toString());
            }
            if (!(socketAddress.getPort() == 0 || socketAddress.getPort() == alreadyStartedAddress.getPort())) {
                boolean $i$a$-check-MockWebServer$start$62 = false;
                String $i$a$-check-MockWebServer$start$62 = "unexpected port";
                throw new IllegalStateException($i$a$-check-MockWebServer$start$62.toString());
            }
            return;
        }
        InetSocketAddress boundSocketAddress = socketAddress;
        try {
            Object it;
            Object object;
            Object object2 = this.serverSocketFactory_;
            if (object2 == null) {
                ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
                Intrinsics.checkNotNull((Object)serverSocketFactory);
                it = object = serverSocketFactory;
                boolean bl = false;
                this.serverSocketFactory_ = it;
                object2 = object;
            }
            ServerSocketFactory serverSocketFactory = object2;
            ServerSocket serverSocket = serverSocketFactory.createServerSocket();
            Intrinsics.checkNotNull((Object)serverSocket);
            it = object = serverSocket;
            boolean bl = false;
            this.serverSocket = it;
            Object serverSocket2 = object;
            ((ServerSocket)serverSocket2).setReuseAddress(socketAddress.getPort() != 0);
            ((ServerSocket)serverSocket2).bind(socketAddress, 50);
            boundSocketAddress = new InetSocketAddress(boundSocketAddress.getAddress(), ((ServerSocket)serverSocket2).getLocalPort());
        }
        finally {
            this.socketAddress_ = boundSocketAddress;
        }
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)this.toString(), (long)0L, (boolean)false, () -> MockWebServer.start$lambda$5(this), (int)2, null);
    }

    private final void acceptConnections() throws Exception {
        int nextConnectionIndex = 0;
        while (true) {
            java.net.Socket socket = null;
            try {
                ServerSocket serverSocket = this.serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                java.net.Socket socket2 = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"accept(...)");
                socket = socket2;
            }
            catch (SocketException e) {
                logger.fine(this + " done accepting connections: " + e.getMessage());
                return;
            }
            MockResponse peek = this.dispatcher.peek();
            if (peek.getOnRequestStart() instanceof SocketEffect.CloseSocket) {
                MockWebServer.dispatchBookkeepingRequest$default(this, nextConnectionIndex++, 0, new MockWebServerSocket(socket), null, 8, null);
                socket.close();
                continue;
            }
            this.openClientSockets.add(socket);
            this.serveConnection(nextConnectionIndex++, socket, peek);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.getStarted()) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return;
        }
        ServerSocket serverSocket2 = serverSocket;
        _UtilJvmKt.closeQuietly((ServerSocket)serverSocket2);
        for (TaskQueue queue : this.taskRunner.activeQueues()) {
            if (!queue.idleLatch().await(5L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"Gave up waiting for queue to shut down");
            }
        }
        this.taskRunnerBackend.shutdown();
    }

    private final void serveConnection(int connectionIndex, java.net.Socket raw, MockResponse firstExchangePeek) {
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)("MockWebServer " + raw.getRemoteSocketAddress()), (long)0L, (boolean)false, () -> MockWebServer.serveConnection$lambda$0(this, connectionIndex, raw, firstExchangePeek), (int)2, null);
    }

    private final void processHandshakeFailure(java.net.Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{UNTRUSTED_TRUST_MANAGER};
        context.init(null, trustManagerArray, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        java.net.Socket socket = sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket socket2 = (SSLSocket)socket;
        try {
            socket2.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket2.close();
            return;
        }
    }

    private final void dispatchBookkeepingRequest(int connectionIndex, int exchangeIndex, MockWebServerSocket socket, RequestLine requestLine) throws InterruptedException {
        RecordedRequest request = RecordedRequestFactoryKt.RecordedRequest$default(requestLine, Headers.Companion.of(new String[0]), null, 0L, null, connectionIndex, exchangeIndex, socket, null, 256, null);
        this.atomicRequestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    static /* synthetic */ void dispatchBookkeepingRequest$default(MockWebServer mockWebServer, int n, int n2, MockWebServerSocket mockWebServerSocket, RequestLine requestLine, int n3, Object object) throws InterruptedException {
        if ((n3 & 8) != 0) {
            requestLine = RecordedRequestFactoryKt.getDEFAULT_REQUEST_LINE_HTTP_1();
        }
        mockWebServer.dispatchBookkeepingRequest(n, n2, mockWebServerSocket, requestLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RecordedRequest readRequest(MockWebServerSocket socket, int connectionIndex, int exchangeIndex) throws IOException {
        RequestLine request = null;
        request = RecordedRequestFactoryKt.getDEFAULT_REQUEST_LINE_HTTP_1();
        Headers.Builder headers = new Headers.Builder();
        long contentLength = 0L;
        contentLength = -1L;
        boolean chunked = false;
        boolean hasBody = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        List chunkSizes = null;
        IOException failure = null;
        try {
            Object object;
            String header;
            String requestLineString = socket.getSource().readUtf8LineStrict();
            if (((CharSequence)requestLineString).length() == 0) {
                throw new ProtocolException("no request because the stream is exhausted");
            }
            request = RecordedRequestFactoryKt.decodeRequestLine(requestLineString);
            while (!(((CharSequence)(header = socket.getSource().readUtf8LineStrict())).length() == 0)) {
                Object lowercaseHeader;
                Internal.addHeaderLenient((Headers.Builder)headers, (String)header);
                object = header;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)((String)object).toLowerCase(locale), (String)"toLowerCase(...)");
                if (contentLength == -1L && StringsKt.startsWith$default((String)lowercaseHeader, (String)"content-length:", (boolean)false, (int)2, null)) {
                    String string = header.substring(15);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    contentLength = Long.parseLong(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                if (!StringsKt.startsWith$default((String)lowercaseHeader, (String)"transfer-encoding:", (boolean)false, (int)2, null)) continue;
                String string = ((String)lowercaseHeader).substring(18);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"chunked")) continue;
                chunked = true;
            }
            MockResponse peek = this.dispatcher.peek();
            for (MockResponse response : peek.getInformationalResponses()) {
                this.writeHttpResponse(socket, response);
            }
            BufferedSink requestBodySink = Okio.buffer((Sink)MockWebServer.withThrottlingAndSocketEffect$default(this, requestBody, peek, peek.getOnRequestBody(), contentLength, socket, null, 16, null));
            object = (Closeable)requestBodySink;
            Throwable throwable = null;
            try {
                Unit unit;
                BufferedSink it = (BufferedSink)object;
                boolean bl = false;
                if (peek.getDoNotReadRequestBody()) {
                    hasBody = false;
                    unit = Unit.INSTANCE;
                } else if (contentLength != -1L) {
                    hasBody = contentLength > 0L || HttpMethod.permitsRequestBody((String)request.getMethod());
                    unit = requestBodySink.write((Source)socket.getSource(), contentLength);
                } else if (chunked) {
                    chunkSizes = new ArrayList();
                    hasBody = true;
                    while (true) {
                        int chunkSize;
                        if ((chunkSize = Integer.parseInt(((Object)StringsKt.trim((CharSequence)socket.getSource().readUtf8LineStrict())).toString(), CharsKt.checkRadix((int)16))) == 0) break;
                        chunkSizes.add(chunkSize);
                        requestBodySink.write((Source)socket.getSource(), (long)chunkSize);
                        this.readEmptyLine(socket.getSource());
                    }
                    this.readEmptyLine(socket.getSource());
                    unit = Unit.INSTANCE;
                } else {
                    hasBody = false;
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (!(!hasBody || HttpMethod.permitsRequestBody((String)request.getMethod()))) {
                boolean bl = false;
                String string = "Request must not have a body: " + request;
                throw new IllegalArgumentException(string.toString());
            }
        }
        catch (IOException e) {
            failure = e;
        }
        return RecordedRequestFactoryKt.RecordedRequest(request, headers.build(), chunkSizes, requestBody.getReceivedByteCount(), hasBody ? requestBody.getBuffer().readByteString() : null, connectionIndex, exchangeIndex, socket, failure);
    }

    private final void handleWebSocketUpgrade(MockWebServerSocket socket, RecordedRequest request, MockResponse response) throws IOException {
        String key = request.getHeaders().get("Sec-WebSocket-Key");
        MockResponse.Builder builder = response.newBuilder();
        String string = key;
        Intrinsics.checkNotNull((Object)string);
        MockResponse webSocketResponse = builder.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.INSTANCE.acceptHeader(string)).build();
        this.writeHttpResponse(socket, webSocketResponse);
        String scheme = request.getHandshake() != null ? "https" : "http";
        String authority = request.getHeaders().get("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + '/').headers(request.getHeaders()).build();
        Response fancyResponse = new Response.Builder().code(webSocketResponse.getCode()).message(webSocketResponse.getMessage()).headers(webSocketResponse.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        WebSocketListener webSocketListener = webSocketResponse.getWebSocketListener();
        Intrinsics.checkNotNull((Object)webSocketListener);
        RealWebSocket webSocket = new RealWebSocket(this.taskRunner, fancyRequest, webSocketListener, (Random)new SecureRandom(), 0L, WebSocketExtensions.Companion.parse(webSocketResponse.getHeaders()), 0L, 60000L);
        String name = "MockWebServer WebSocket " + request.getUrl().encodedPath();
        webSocket.initReaderAndWriter(name, (BufferedSocket)socket, false);
        webSocket.loopReader(fancyResponse);
        socket.awaitClosed();
    }

    private final void writeHttpResponse(MockWebServerSocket socket, MockResponse response) throws IOException {
        socket.sleepWhileOpen(response.getHeadersDelayNanos());
        socket.getSink().writeUtf8(response.getStatus());
        socket.getSink().writeUtf8("\r\n");
        this.writeHeaders(socket.getSink(), response.getHeaders());
        if (response.getSocketHandler() != null) {
            response.getSocketHandler().handle((Socket)socket);
            return;
        }
        MockResponseBody mockResponseBody = response.getBody();
        if (mockResponseBody == null) {
            return;
        }
        MockResponseBody body = mockResponseBody;
        socket.sleepWhileOpen(response.getBodyDelayNanos());
        BufferedSink responseBodySink = Okio.buffer((Sink)MockWebServer.withThrottlingAndSocketEffect$default(this, (Sink)socket.getSink(), response, response.getOnResponseBody(), body.getContentLength(), socket, null, 16, null));
        body.writeTo(responseBodySink);
        responseBodySink.emit();
        socket.sleepWhileOpen(response.getTrailersDelayNanos());
        if (StringsKt.equals((String)"chunked", (String)response.getHeaders().get("Transfer-Encoding"), (boolean)true)) {
            this.writeHeaders(socket.getSink(), response.getTrailers());
        }
    }

    private final void writeHeaders(BufferedSink sink2, Headers headers) throws IOException {
        for (Pair pair : headers) {
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            sink2.writeUtf8(name);
            sink2.writeUtf8(": ");
            sink2.writeUtf8(value);
            sink2.writeUtf8("\r\n");
        }
        sink2.writeUtf8("\r\n");
        sink2.flush();
    }

    private final Sink withThrottlingAndSocketEffect(Sink $this$withThrottlingAndSocketEffect, MockResponse policy, SocketEffect socketEffect, long expectedByteCount, MockWebServerSocket socket, Http2Stream stream) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = $this$withThrottlingAndSocketEffect;
        if (policy.getThrottlePeriodNanos() > 0L) {
            result.element = new ThrottledSink(socket, (Sink)result.element, policy.getThrottleBytesPerPeriod(), policy.getThrottlePeriodNanos());
        }
        if (socketEffect != null) {
            long halfwayByteCount = expectedByteCount != -1L ? expectedByteCount / (long)2 : 0L;
            result.element = new TriggerSink((Sink)result.element, halfwayByteCount, (Function0<Unit>)((Function0)() -> MockWebServer.withThrottlingAndSocketEffect$lambda$0(result, this, socketEffect, socket, stream)));
        }
        return (Sink)result.element;
    }

    static /* synthetic */ Sink withThrottlingAndSocketEffect$default(MockWebServer mockWebServer, Sink sink2, MockResponse mockResponse, SocketEffect socketEffect, long l, MockWebServerSocket mockWebServerSocket, Http2Stream http2Stream, int n, Object object) {
        if ((n & 0x10) != 0) {
            http2Stream = null;
        }
        return mockWebServer.withThrottlingAndSocketEffect(sink2, mockResponse, socketEffect, l, mockWebServerSocket, http2Stream);
    }

    private final boolean handleSocketEffect(SocketEffect effect, MockWebServerSocket socket, Http2Stream stream) {
        if (effect == null) {
            return false;
        }
        SocketEffect socketEffect = effect;
        if (socketEffect instanceof SocketEffect.CloseStream) {
            if (stream != null) {
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(((SocketEffect.CloseStream)effect).getHttp2ErrorCode());
                Intrinsics.checkNotNull((Object)errorCode);
                stream.close(errorCode, null);
            } else {
                socket.close();
            }
        } else if (Intrinsics.areEqual((Object)socketEffect, (Object)SocketEffect.ShutdownConnection.INSTANCE)) {
            if (stream != null) {
                stream.getConnection().shutdown(ErrorCode.NO_ERROR);
            } else {
                socket.close();
            }
        } else if (socketEffect instanceof SocketEffect.CloseSocket) {
            if (((SocketEffect.CloseSocket)effect).getShutdownInput()) {
                socket.shutdownInput();
            }
            if (((SocketEffect.CloseSocket)effect).getShutdownOutput()) {
                socket.shutdownOutput();
            }
            if (((SocketEffect.CloseSocket)effect).getCloseSocket()) {
                socket.close();
            }
        } else {
            if (Intrinsics.areEqual((Object)socketEffect, (Object)SocketEffect.Stall.INSTANCE)) {
                socket.sleepWhileOpen(TimeUnit.MINUTES.toNanos(60L));
                throw new IllegalStateException("expected timeout".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    static /* synthetic */ boolean handleSocketEffect$default(MockWebServer mockWebServer, SocketEffect socketEffect, MockWebServerSocket mockWebServerSocket, Http2Stream http2Stream, int n, Object object) {
        if ((n & 4) != 0) {
            http2Stream = null;
        }
        return mockWebServer.handleSocketEffect(socketEffect, mockWebServerSocket, http2Stream);
    }

    private final void readEmptyLine(BufferedSource source2) throws IOException {
        String line = source2.readUtf8LineStrict();
        if (!(((CharSequence)line).length() == 0)) {
            boolean bl = false;
            String string = "Expected empty but was: " + line;
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        InetSocketAddress socketAddress = this.socketAddress_;
        return this.closed ? "MockWebServer{closed}" : (socketAddress != null ? "MockWebServer{port=" + socketAddress.getPort() + '}' : "MockWebServer{new}");
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockWebServer.start$default(this, 0, 1, null);
    }

    private static final Unit start$lambda$5(MockWebServer this$0) {
        try {
            logger.fine(this$0 + " starting to accept connections");
            this$0.acceptConnections();
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, this$0 + " failed unexpectedly", e);
        }
        ServerSocket serverSocket = this$0.serverSocket;
        if (serverSocket != null) {
            _UtilJvmKt.closeQuietly((ServerSocket)serverSocket);
        }
        Iterator<java.net.Socket> openClientSocket = this$0.openClientSockets.iterator();
        while (openClientSocket.hasNext()) {
            java.net.Socket socket = openClientSocket.next();
            Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"next(...)");
            _UtilJvmKt.closeQuietly((java.net.Socket)socket);
            openClientSocket.remove();
        }
        Iterator<Http2Connection> httpConnection = this$0.openConnections.iterator();
        while (httpConnection.hasNext()) {
            Http2Connection http2Connection = httpConnection.next();
            Intrinsics.checkNotNullExpressionValue((Object)http2Connection, (String)"next(...)");
            _UtilCommonKt.closeQuietly((Closeable)((Closeable)http2Connection));
            httpConnection.remove();
        }
        this$0.dispatcher.close();
        return Unit.INSTANCE;
    }

    private static final Unit serveConnection$lambda$0(MockWebServer this$0, int $connectionIndex, java.net.Socket $raw, MockResponse $firstExchangePeek) {
        try {
            this$0.new SocketHandler($connectionIndex, $raw, $firstExchangePeek).handle();
        }
        catch (IOException e) {
            logger.fine(this$0 + " connection from " + $raw.getInetAddress() + " failed: " + e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this$0 + " connection from " + $raw.getInetAddress() + " crashed", e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit withThrottlingAndSocketEffect$lambda$0(Ref.ObjectRef $result, MockWebServer this$0, SocketEffect $socketEffect, MockWebServerSocket $socket, Http2Stream $stream) {
        ((Sink)$result.element).flush();
        this$0.handleSocketEffect($socketEffect, $socket, $stream);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmockwebserver3/MockWebServer$Companion;", "", "<init>", "()V", "CLIENT_AUTH_NONE", "", "CLIENT_AUTH_REQUESTED", "CLIENT_AUTH_REQUIRED", "UNTRUSTED_TRUST_MANAGER", "mockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1", "Lmockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver3"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmockwebserver3/MockWebServer$Http2SocketHandler;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "connectionIndex", "", "socket", "Lmockwebserver3/internal/MockWebServerSocket;", "protocol", "Lokhttp3/Protocol;", "<init>", "(Lmockwebserver3/MockWebServer;ILmockwebserver3/internal/MockWebServerSocket;Lokhttp3/Protocol;)V", "nextExchangeIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "onStream", "", "stream", "Lokhttp3/internal/http2/Http2Stream;", "readRequest", "Lmockwebserver3/RecordedRequest;", "toHttp2Headers", "", "Lokhttp3/internal/http2/Header;", "Lmockwebserver3/MockResponse;", "writeResponse", "request", "response", "pushPromises", "promises", "Lmockwebserver3/PushPromise;", "mockwebserver3"})
    private final class Http2SocketHandler
    extends Http2Connection.Listener {
        private final int connectionIndex;
        @NotNull
        private final MockWebServerSocket socket;
        @NotNull
        private final Protocol protocol;
        @NotNull
        private final AtomicInteger nextExchangeIndex;

        public Http2SocketHandler(@NotNull int connectionIndex, @NotNull MockWebServerSocket socket, Protocol protocol) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.connectionIndex = connectionIndex;
            this.socket = socket;
            this.protocol = protocol;
            this.nextExchangeIndex = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStream(@NotNull Http2Stream stream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            if (MockWebServer.this.handleSocketEffect(peek.getOnRequestStart(), this.socket, stream)) {
                MockWebServer.this.dispatchBookkeepingRequest(this.connectionIndex, this.nextExchangeIndex.getAndIncrement(), this.socket, RecordedRequestFactoryKt.getDEFAULT_REQUEST_LINE_HTTP_2());
                return;
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            try {
                if (MockWebServer.this.handleSocketEffect(peek.getOnResponseStart(), this.socket, stream)) {
                    return;
                }
                this.writeResponse(stream, request, response);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol);
                }
                MockWebServer.this.handleSocketEffect(peek.getOnResponseEnd(), this.socket, stream);
            }
            finally {
                if (response.getShutdownServer()) {
                    MockWebServer.this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = Http2Stream.takeHeaders$default((Http2Stream)stream, (boolean)false, (int)1, null);
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            for (Pair pair : streamHeaders) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                if (Intrinsics.areEqual((Object)name, (Object)":method")) {
                    method = value;
                } else if (Intrinsics.areEqual((Object)name, (Object)":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add(name, value);
                } else {
                    throw new IllegalStateException();
                }
                if (!Intrinsics.areEqual((Object)name, (Object)"expect") || !StringsKt.equals((String)value, (String)"100-continue", (boolean)true)) continue;
                readBody = false;
            }
            Headers headers = httpHeaders.build();
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            for (MockResponse response : peek.getInformationalResponses()) {
                this.socket.sleepWhileOpen(response.getHeadersDelayNanos());
                stream.writeHeaders(this.toHttp2Headers(response), false, true);
                if (response.getCode() != 100) continue;
                readBody = true;
            }
            RequestLine requestLine = new RequestLine(method, path, "HTTP/2");
            IOException exception = null;
            ByteString bodyByteString = null;
            if (readBody && peek.getSocketHandler() == null && !peek.getDoNotReadRequestBody()) {
                Buffer body = new Buffer();
                try {
                    String contentLengthString = headers.get("content-length");
                    String string = contentLengthString;
                    BufferedSink requestBodySink = Okio.buffer((Sink)MockWebServer.this.withThrottlingAndSocketEffect((Sink)body, peek, peek.getOnRequestBody(), string != null ? Long.parseLong(string) : Long.MAX_VALUE, this.socket, stream));
                    Closeable closeable = (Closeable)requestBodySink;
                    Throwable throwable = null;
                    try {
                        BufferedSink it = (BufferedSink)closeable;
                        boolean bl = false;
                        long l = it.writeAll((Source)stream.getSource());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    exception = e;
                }
                finally {
                    bodyByteString = body.readByteString();
                }
            }
            ByteString byteString = bodyByteString;
            return RecordedRequestFactoryKt.RecordedRequest(requestLine, headers, null, byteString != null ? (long)byteString.size() : 0L, HttpMethod.permitsRequestBody((String)method) ? bodyByteString : null, this.connectionIndex, this.nextExchangeIndex.getAndIncrement(), this.socket, exception);
        }

        private final List<Header> toHttp2Headers(MockResponse $this$toHttp2Headers) {
            List result = new ArrayList();
            ((Collection)result).add(new Header(Header.RESPONSE_STATUS, String.valueOf($this$toHttp2Headers.getCode())));
            for (Pair pair : $this$toHttp2Headers.getHeaders()) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                ((Collection)result).add(new Header(name, value));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeResponse(Http2Stream stream, RecordedRequest request, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            stream.getConnection().setSettings(settings);
            long bodyDelayNanos = response.getBodyDelayNanos();
            Headers trailers = response.getTrailers();
            MockResponseBody body = response.getBody();
            mockwebserver3.SocketHandler socketHandler = response.getSocketHandler();
            boolean outFinished = body == null && response.getPushPromises().isEmpty() && socketHandler == null;
            boolean flushHeaders = body == null || bodyDelayNanos != 0L;
            if (!(!outFinished || trailers.size() == 0)) {
                boolean bl = false;
                String string = "unsupported: no body and non-empty trailers " + trailers;
                throw new IllegalArgumentException(string.toString());
            }
            this.socket.sleepWhileOpen(response.getHeadersDelayNanos());
            stream.writeHeaders(this.toHttp2Headers(response), outFinished, flushHeaders);
            if (trailers.size() > 0) {
                stream.enqueueTrailers(trailers);
            }
            this.pushPromises(stream, request, response.getPushPromises());
            if (body != null) {
                this.socket.sleepWhileOpen(bodyDelayNanos);
                BufferedSink responseBodySink = Okio.buffer((Sink)MockWebServer.this.withThrottlingAndSocketEffect((Sink)stream.getSink(), response, response.getOnResponseBody(), body.getContentLength(), this.socket, stream));
                Closeable closeable = (Closeable)responseBodySink;
                Throwable throwable = null;
                try {
                    BufferedSink it = (BufferedSink)closeable;
                    boolean bl = false;
                    body.writeTo(it);
                    if (response.getTrailersDelayNanos() != 0L) {
                        it.flush();
                        this.socket.sleepWhileOpen(response.getTrailersDelayNanos());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else if (socketHandler != null) {
                socketHandler.handle((Socket)stream);
            } else if (!outFinished) {
                this.socket.sleepWhileOpen(response.getTrailersDelayNanos());
                stream.close(ErrorCode.NO_ERROR, null);
            }
        }

        private final void pushPromises(Http2Stream stream, RecordedRequest request, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                List pushedHeaders = new ArrayList();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.getPath()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.getMethod()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.getPath()));
                Headers pushPromiseHeaders = pushPromise.getHeaders();
                for (Pair pair : pushPromiseHeaders) {
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    pushedHeaders.add(new Header(name, value));
                }
                RequestLine requestLine = new RequestLine(pushPromise.getMethod(), pushPromise.getPath(), "HTTP/2");
                MockWebServer.this.requestQueue.add(RecordedRequestFactoryKt.RecordedRequest$default(requestLine, pushPromise.getHeaders(), null, 0L, null, this.connectionIndex, this.nextExchangeIndex.getAndIncrement(), this.socket, null, 256, null));
                boolean hasBody = pushPromise.getResponse().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, request, pushPromise.getResponse());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmockwebserver3/MockWebServer$SocketHandler;", "", "connectionIndex", "", "raw", "Ljava/net/Socket;", "firstExchangePeek", "Lmockwebserver3/MockResponse;", "<init>", "(Lmockwebserver3/MockWebServer;ILjava/net/Socket;Lmockwebserver3/MockResponse;)V", "nextExchangeIndex", "handle", "", "processTunnelRequests", "", "processOneRequest", "socket", "Lmockwebserver3/internal/MockWebServerSocket;", "mockwebserver3"})
    public final class SocketHandler {
        private final int connectionIndex;
        @NotNull
        private final java.net.Socket raw;
        @NotNull
        private final MockResponse firstExchangePeek;
        private int nextExchangeIndex;

        public SocketHandler(@NotNull int connectionIndex, @NotNull java.net.Socket raw, MockResponse firstExchangePeek) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)firstExchangePeek, (String)"firstExchangePeek");
            this.connectionIndex = connectionIndex;
            this.raw = raw;
            this.firstExchangePeek = firstExchangePeek;
        }

        public final void handle() throws Exception {
            if (!this.processTunnelRequests()) {
                return;
            }
            Protocol protocol = null;
            MockWebServerSocket socket = null;
            if (MockWebServer.this.sslSocketFactory != null) {
                if (this.firstExchangePeek.getFailHandshake()) {
                    int n = this.nextExchangeIndex;
                    this.nextExchangeIndex = n + 1;
                    MockWebServer.dispatchBookkeepingRequest$default(MockWebServer.this, this.connectionIndex, n, new MockWebServerSocket(this.raw), null, 8, null);
                    MockWebServer.this.processHandshakeFailure(this.raw);
                    return;
                }
                SSLSocketFactory sSLSocketFactory = MockWebServer.this.sslSocketFactory;
                Intrinsics.checkNotNull((Object)sSLSocketFactory);
                java.net.Socket socket2 = sSLSocketFactory.createSocket(this.raw, this.raw.getInetAddress().getHostAddress(), this.raw.getPort(), true);
                Intrinsics.checkNotNull((Object)socket2, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                SSLSocket sslSocket = (SSLSocket)socket2;
                sslSocket.setUseClientMode(false);
                if (MockWebServer.this.clientAuth == 2) {
                    sslSocket.setNeedClientAuth(true);
                } else if (MockWebServer.this.clientAuth == 1) {
                    sslSocket.setWantClientAuth(true);
                }
                MockWebServer.this.openClientSockets.add(sslSocket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.getProtocols());
                }
                sslSocket.startHandshake();
                socket = new MockWebServerSocket(sslSocket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    String protocolString = Platform.Companion.get().getSelectedProtocol(sslSocket);
                    String string = protocolString;
                    protocol = string != null ? Protocol.Companion.get(string) : Protocol.HTTP_1_1;
                    Platform.Companion.get().afterHandshake(sslSocket);
                } else {
                    protocol = Protocol.HTTP_1_1;
                }
                MockWebServer.this.openClientSockets.remove(this.raw);
            } else {
                protocol = MockWebServer.this.getProtocols().contains(Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_1_1;
                socket = new MockWebServerSocket(this.raw);
            }
            if (Intrinsics.areEqual((Object)this.firstExchangePeek.getOnRequestStart(), (Object)SocketEffect.Stall.INSTANCE)) {
                int sslSocket = this.nextExchangeIndex;
                this.nextExchangeIndex = sslSocket + 1;
                MockWebServer.dispatchBookkeepingRequest$default(MockWebServer.this, this.connectionIndex, sslSocket, socket, null, 8, null);
                return;
            }
            if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                Http2SocketHandler http2SocketHandler = new Http2SocketHandler(this.connectionIndex, socket, protocol);
                Http2Connection connection = new Http2Connection.Builder(false, MockWebServer.this.taskRunner).socket((BufferedSocket)socket, socket.getJavaNetSocket().getRemoteSocketAddress().toString()).listener((Http2Connection.Listener)http2SocketHandler).build();
                Http2Connection.start$default((Http2Connection)connection, (boolean)false, (int)1, null);
                MockWebServer.this.openConnections.add(connection);
                MockWebServer.this.openClientSockets.remove(socket.getJavaNetSocket());
                return;
            }
            if (protocol != Protocol.HTTP_1_1) {
                throw new AssertionError();
            }
            while (this.processOneRequest(socket)) {
            }
            if (this.nextExchangeIndex == 0) {
                logger.warning(MockWebServer.this + " connection from " + this.raw.getInetAddress() + " didn't make a request");
            }
            socket.close();
            MockWebServer.this.openClientSockets.remove(socket.getJavaNetSocket());
        }

        private final boolean processTunnelRequests() throws IOException, InterruptedException {
            if (!MockWebServer.this.getDispatcher().peek().getInTunnel()) {
                return true;
            }
            MockWebServerSocket socket = new MockWebServerSocket(this.raw);
            do {
                boolean socketStillGood;
                if (socketStillGood = this.processOneRequest(socket)) continue;
                this.raw.close();
                MockWebServer.this.openClientSockets.remove(this.raw);
                return false;
            } while (MockWebServer.this.getDispatcher().peek().getInTunnel());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean processOneRequest(MockWebServerSocket socket) throws IOException, InterruptedException {
            if (socket.getSource().exhausted()) {
                return false;
            }
            int n = this.nextExchangeIndex;
            this.nextExchangeIndex = n + 1;
            RecordedRequest request = MockWebServer.this.readRequest(socket, this.connectionIndex, n);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return false;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            try {
                boolean responseWantsWebSocket;
                if (MockWebServer.handleSocketEffect$default(MockWebServer.this, response.getOnResponseStart(), socket, null, 4, null)) {
                    boolean bl = false;
                    return bl;
                }
                boolean reuseSocket = true;
                boolean requestWantsSocket = StringsKt.equals((String)"Upgrade", (String)request.getHeaders().get("Connection"), (boolean)true);
                boolean requestWantsWebSocket = requestWantsSocket && StringsKt.equals((String)"websocket", (String)request.getHeaders().get("Upgrade"), (boolean)true);
                boolean responseWantsSocket = response.getSocketHandler() != null;
                boolean bl = responseWantsWebSocket = response.getWebSocketListener() != null;
                if (requestWantsWebSocket && responseWantsWebSocket) {
                    MockWebServer.this.handleWebSocketUpgrade(socket, request, response);
                    reuseSocket = false;
                } else if (requestWantsSocket && responseWantsSocket) {
                    MockWebServer.this.writeHttpResponse(socket, response);
                    reuseSocket = false;
                } else {
                    MockWebServer.this.writeHttpResponse(socket, response);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response);
                }
                if (MockWebServer.handleSocketEffect$default(MockWebServer.this, response.getOnResponseEnd(), socket, null, 4, null)) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = reuseSocket;
                return bl3;
            }
            finally {
                if (response.getShutdownServer()) {
                    MockWebServer.this.close();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lmockwebserver3/MockWebServer$TruncatingBuffer;", "Lokio/Sink;", "remainingByteCount", "", "<init>", "(J)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "receivedByteCount", "getReceivedByteCount", "()J", "setReceivedByteCount", "write", "", "source", "byteCount", "flush", "timeout", "Lokio/Timeout;", "close", "mockwebserver3"})
    private static final class TruncatingBuffer
    implements Sink {
        private long remainingByteCount;
        @NotNull
        private final Buffer buffer;
        private long receivedByteCount;

        public TruncatingBuffer(long remainingByteCount) {
            this.remainingByteCount = remainingByteCount;
            this.buffer = new Buffer();
        }

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        public final long getReceivedByteCount() {
            return this.receivedByteCount;
        }

        public final void setReceivedByteCount(long l) {
            this.receivedByteCount = l;
        }

        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            long toSkip;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source2.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source2.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        public void flush() throws IOException {
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() throws IOException {
        }
    }
}

