/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.spi.ElementSource;
import com.squarespace.jersey2.guice.BindingUtils;
import com.squarespace.jersey2.guice.GuiceBinder;
import com.squarespace.jersey2.guice.GuiceJustInTimeResolver;
import com.squarespace.jersey2.guice.GuiceScopeContext;
import com.squarespace.jersey2.guice.GuiceServiceLocator;
import com.squarespace.jersey2.guice.GuiceServiceLocatorFactory;
import com.squarespace.jersey2.guice.GuiceServiceLocatorGenerator;
import com.squarespace.jersey2.guice.GuiceServiceLocatorGeneratorStub;
import com.squarespace.jersey2.guice.JerseyModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.jvnet.hk2.internal.DefaultClassAnalyzer;
import org.jvnet.hk2.internal.DynamicConfigurationImpl;
import org.jvnet.hk2.internal.DynamicConfigurationServiceImpl;
import org.jvnet.hk2.internal.InstantiationServiceImpl;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.ServiceLocatorRuntimeImpl;
import org.jvnet.hk2.internal.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyGuiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JerseyGuiceUtils.class);
    private static final String MODIFIERS_FIELD = "modifiers";
    private static final String PREFIX = "GuiceServiceLocator-";
    private static final AtomicInteger NTH = new AtomicInteger();
    private static boolean SPI_CHECKED = false;
    private static boolean SPI_PRESENT = false;

    private JerseyGuiceUtils() {
    }

    public static void install(Injector injector) {
        ServiceLocator locator = (ServiceLocator)injector.getInstance(ServiceLocator.class);
        GuiceServiceLocatorGenerator generator = JerseyGuiceUtils.getOrCreateGuiceServiceLocatorGenerator();
        generator.add(locator);
    }

    public static void install(ServiceLocatorGenerator delegate) {
        GuiceServiceLocatorGenerator generator = JerseyGuiceUtils.getOrCreateGuiceServiceLocatorGenerator();
        generator.delegate(delegate);
    }

    public static void reset() {
        GuiceServiceLocatorGenerator generator = JerseyGuiceUtils.getOrCreateGuiceServiceLocatorGenerator();
        generator.reset();
    }

    private static synchronized GuiceServiceLocatorGenerator getOrCreateGuiceServiceLocatorGenerator() {
        if (JerseyGuiceUtils.isProviderPresent()) {
            GuiceServiceLocatorGenerator generator = (GuiceServiceLocatorGenerator)GuiceServiceLocatorGeneratorStub.get();
            if (generator == null) {
                generator = new GuiceServiceLocatorGenerator();
                GuiceServiceLocatorGeneratorStub.install((ServiceLocatorGenerator)generator);
            }
            return generator;
        }
        GuiceServiceLocatorFactory factory = JerseyGuiceUtils.getOrCreateFactory();
        if (factory != null) {
            GuiceServiceLocatorGenerator generator = (GuiceServiceLocatorGenerator)factory.get();
            if (generator == null) {
                generator = new GuiceServiceLocatorGenerator();
                factory.install(generator);
            }
            return generator;
        }
        throw new IllegalStateException();
    }

    private static synchronized boolean isProviderPresent() {
        if (!SPI_CHECKED) {
            SPI_CHECKED = true;
            ServiceLocatorGenerator generator = JerseyGuiceUtils.lookupSPI();
            if (generator instanceof GuiceServiceLocatorGeneratorStub) {
                SPI_PRESENT = true;
            }
            if (!SPI_PRESENT) {
                LOG.warn("It appears jersey2-guice-spi is either not present or in conflict with some other Jar: {}", (Object)generator);
            }
        }
        return SPI_PRESENT;
    }

    private static ServiceLocatorGenerator lookupSPI() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceLocatorGenerator>(){

            @Override
            public ServiceLocatorGenerator run() {
                try {
                    ClassLoader classLoader = JerseyGuiceUtils.class.getClassLoader();
                    ServiceLoader<ServiceLocatorGenerator> providers = ServiceLoader.load(ServiceLocatorGenerator.class, classLoader);
                    Iterator<ServiceLocatorGenerator> iterator = providers.iterator();
                    if (iterator.hasNext()) {
                        ServiceLocatorGenerator generator = iterator.next();
                        return generator;
                    }
                }
                catch (Throwable th) {
                    LOG.warn("Exception", th);
                }
                return null;
            }
        });
    }

    private static synchronized GuiceServiceLocatorFactory getOrCreateFactory() {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        if (factory instanceof GuiceServiceLocatorFactory) {
            return (GuiceServiceLocatorFactory)factory;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Attempting to install (using relfection) a Guice-aware ServiceLocatorFactory...");
        }
        try {
            GuiceServiceLocatorFactory guiceServiceLocatorFactory = new GuiceServiceLocatorFactory(factory);
            Class<ServiceLocatorFactory> clazz = ServiceLocatorFactory.class;
            Field field = clazz.getDeclaredField("INSTANCE");
            JerseyGuiceUtils.set(field, null, (Object)guiceServiceLocatorFactory);
            return guiceServiceLocatorFactory;
        }
        catch (Exception err) {
            err.printStackTrace();
            LOG.error("Exception", (Throwable)err);
            return null;
        }
    }

    public static ServiceLocator newServiceLocator() {
        return JerseyGuiceUtils.newServiceLocator(null);
    }

    public static ServiceLocator newServiceLocator(String name) {
        return JerseyGuiceUtils.newServiceLocator(name, null);
    }

    public static ServiceLocator newServiceLocator(String name, ServiceLocator parent) {
        if (parent != null && !(parent instanceof ServiceLocatorImpl)) {
            throw new IllegalArgumentException("name=" + name + ", parent=" + parent);
        }
        if (name == null) {
            name = PREFIX;
        }
        if (name.endsWith("-")) {
            name = name + NTH.incrementAndGet();
        }
        GuiceServiceLocator locator = new GuiceServiceLocator(name, parent);
        DynamicConfigurationImpl config = new DynamicConfigurationImpl((ServiceLocatorImpl)locator);
        config.bind((Descriptor)Utilities.getLocatorDescriptor((ServiceLocator)locator));
        ActiveDescriptor<InjectionResolver<Inject>> threeThirtyResolver = BindingUtils.newThreeThirtyInjectionResolverDescriptor((ServiceLocator)locator);
        config.addActiveDescriptor(threeThirtyResolver);
        config.addActiveDescriptor(BindingUtils.newGuiceInjectionResolverDescriptor((ServiceLocator)locator, threeThirtyResolver));
        config.bind((Descriptor)BuilderHelper.link(DynamicConfigurationServiceImpl.class, (boolean)false).to(DynamicConfigurationService.class).in(Singleton.class.getName()).localOnly().build());
        config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)new DefaultClassAnalyzer((ServiceLocatorImpl)locator)));
        config.bind((Descriptor)BuilderHelper.createDescriptorFromClass(ServiceLocatorRuntimeImpl.class));
        config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)new InstantiationServiceImpl()));
        config.commit();
        return locator;
    }

    public static ServiceLocator link(ServiceLocator locator, Injector injector) {
        Map<Key<?>, Binding<?>> bindings = JerseyGuiceUtils.gatherBindings(injector);
        Set<Binder> binders = JerseyGuiceUtils.toBinders(bindings);
        return JerseyGuiceUtils.link(locator, injector, binders);
    }

    private static Map<Key<?>, Binding<?>> gatherBindings(Injector injector) {
        HashMap dst = new HashMap();
        for (Injector current = injector; current != null; current = current.getParent()) {
            dst.putAll(current.getBindings());
        }
        return dst;
    }

    private static ServiceLocator link(ServiceLocator locator, Injector injector, Iterable<? extends Binder> binders) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        GuiceJustInTimeResolver resolver = new GuiceJustInTimeResolver(locator, injector);
        dc.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)resolver));
        dc.addActiveDescriptor(GuiceScopeContext.class);
        JerseyGuiceUtils.bind(locator, dc, (Binder)new MessagingBinders.HeaderDelegateProviders());
        for (Binder binder : binders) {
            JerseyGuiceUtils.bind(locator, dc, binder);
        }
        dc.commit();
        return locator;
    }

    private static void bind(ServiceLocator locator, DynamicConfiguration dc, Binder binder) {
        locator.inject((Object)binder);
        binder.bind(dc);
    }

    private static Set<Binder> toBinders(Map<Key<?>, Binding<?>> bindings) {
        HashSet<Binder> binders = new HashSet<Binder>();
        for (Map.Entry<Key<?>, Binding<?>> entry : bindings.entrySet()) {
            Binding<?> binding;
            Key<?> key;
            block6: {
                key = entry.getKey();
                binding = entry.getValue();
                Object source = binding.getSource();
                if (!(source instanceof ElementSource)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Adding binding: key={}, source={}", key, source);
                    }
                    binders.add((Binder)new GuiceBinder(key, binding));
                    continue;
                }
                ElementSource element = (ElementSource)source;
                List names = element.getModuleClassNames();
                String name = (String)names.get(0);
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> module = classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
                    if (JerseyModule.class.isAssignableFrom(module)) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Ignoring binding {} in {}", key, module);
                        continue;
                    }
                }
                catch (ClassNotFoundException err) {
                    if (!LOG.isWarnEnabled()) break block6;
                    LOG.warn("Unavailable to load class in order to validate module: name={}", (Object)name);
                }
            }
            binders.add((Binder)new GuiceBinder(key, binding));
        }
        return binders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void set(Field field, Object instance, Object value) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        field.setAccessible(true);
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            JerseyGuiceUtils.setModifiers(field, modifiers & 0xFFFFFFEF);
            try {
                field.set(instance, value);
            }
            finally {
                JerseyGuiceUtils.setModifiers(field, modifiers | 0x10);
            }
        } else {
            field.set(instance, value);
        }
    }

    private static void setModifiers(Field dst, int modifiers) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = Field.class.getDeclaredField(MODIFIERS_FIELD);
        field.setAccessible(true);
        field.setInt(dst, modifiers);
    }
}

