/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.Injector;
import com.google.inject.servlet.RequestScoped;
import com.squarespace.jersey2.guice.JerseyGuiceUtils;
import com.squarespace.jersey2.guice.JerseyModule;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.glassfish.hk2.api.ServiceLocator;

public class JerseyGuiceModule
extends JerseyModule {
    private final ServiceLocator locator;

    public JerseyGuiceModule(String name) {
        this(JerseyGuiceUtils.newServiceLocator(name));
    }

    public JerseyGuiceModule(ServiceLocator locator) {
        this.locator = locator;
    }

    protected void configure() {
        com.google.inject.Provider injector = this.getProvider(Injector.class);
        this.bind(ServiceLocator.class).toProvider((Provider)new ServiceLocatorProvider((Provider<Injector>)injector, this.locator)).in(Singleton.class);
        com.google.inject.Provider provider = this.getProvider(ServiceLocator.class);
        this.bind(Application.class).toProvider(new JerseyProvider<Application>((Provider<ServiceLocator>)provider, Application.class));
        this.bind(Providers.class).toProvider(new JerseyProvider<Providers>((Provider<ServiceLocator>)provider, Providers.class));
        this.bind(UriInfo.class).toProvider(new JerseyProvider<UriInfo>((Provider<ServiceLocator>)provider, UriInfo.class)).in(RequestScoped.class);
        this.bind(HttpHeaders.class).toProvider(new JerseyProvider<HttpHeaders>((Provider<ServiceLocator>)provider, HttpHeaders.class)).in(RequestScoped.class);
        this.bind(SecurityContext.class).toProvider(new JerseyProvider<SecurityContext>((Provider<ServiceLocator>)provider, SecurityContext.class)).in(RequestScoped.class);
        this.bind(Request.class).toProvider(new JerseyProvider<Request>((Provider<ServiceLocator>)provider, Request.class)).in(RequestScoped.class);
    }

    private static class ServiceLocatorProvider
    implements Provider<ServiceLocator> {
        private final Provider<Injector> provider;
        private final ServiceLocator locator;

        @Inject
        public ServiceLocatorProvider(Provider<Injector> provider, ServiceLocator locator) {
            this.provider = provider;
            this.locator = locator;
        }

        public ServiceLocator get() {
            Injector injector = (Injector)this.provider.get();
            JerseyGuiceUtils.link(this.locator, injector);
            return this.locator;
        }
    }

    private static class JerseyProvider<T>
    implements Provider<T> {
        private Provider<ServiceLocator> provider;
        private final Class<T> type;

        public JerseyProvider(Provider<ServiceLocator> provider, Class<T> type) {
            this.provider = provider;
            this.type = type;
        }

        public T get() {
            ServiceLocator locator = (ServiceLocator)this.provider.get();
            return (T)locator.getService(this.type, new Annotation[0]);
        }
    }
}

