/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.squarespace.jersey2.guice.AbstractInjectionResolver;
import com.squarespace.jersey2.guice.BindingUtils;
import javax.inject.Inject;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.UnsatisfiedDependencyException;

class GuiceThreeThirtyResolver
extends AbstractInjectionResolver<Inject> {
    private final ServiceLocator locator;

    public GuiceThreeThirtyResolver(ServiceLocator locator) {
        this.locator = locator;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor descriptor = this.locator.getInjecteeDescriptor(injectee);
        if (descriptor == null) {
            if (BindingUtils.isNullable(injectee)) {
                return null;
            }
            throw new MultiException((Throwable)new UnsatisfiedDependencyException(injectee));
        }
        return this.locator.getService(descriptor, root, injectee);
    }
}

