/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;

class GuiceServiceLocatorGenerator
implements ServiceLocatorGenerator {
    private final ServiceLocatorGenerator generator = new ServiceLocatorGeneratorImpl();
    private final ConcurrentMap<String, ServiceLocator> locators = new ConcurrentHashMap<String, ServiceLocator>();
    private final AtomicReference<ServiceLocatorGenerator> delegateRef = new AtomicReference();

    GuiceServiceLocatorGenerator() {
    }

    public void delegate(ServiceLocatorGenerator delegate) {
        this.delegateRef.set(delegate);
    }

    public void add(ServiceLocator locator) {
        String name = locator.getName();
        if (this.locators.putIfAbsent(name, locator) != null) {
            throw new IllegalStateException("Duplicate name: " + name);
        }
    }

    public Collection<ServiceLocator> locators() {
        return this.locators.values();
    }

    public void reset() {
        this.locators.clear();
        this.delegateRef.set(null);
    }

    public ServiceLocator create(String name, ServiceLocator parent) {
        ServiceLocator locator = (ServiceLocator)this.locators.remove(name);
        if (locator != null) {
            return locator;
        }
        ServiceLocatorGenerator delegate = this.delegateRef.get();
        if (delegate != null && (locator = delegate.create(name, parent)) != null) {
            return locator;
        }
        return this.generator.create(name, parent);
    }
}

