/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.ServiceLocatorListener;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;

class GuiceServiceLocatorFactory
extends ServiceLocatorFactory {
    private final AtomicReference<ServiceLocatorGenerator> generatorRef = new AtomicReference();
    private final ServiceLocatorFactory factory;

    public GuiceServiceLocatorFactory(ServiceLocatorFactory factory) {
        this.factory = factory;
    }

    public ServiceLocatorGenerator install(ServiceLocatorGenerator generator) {
        return this.generatorRef.getAndSet(generator);
    }

    public ServiceLocatorGenerator get() {
        return this.generatorRef.get();
    }

    public ServiceLocator create(String name) {
        return this.create(name, null);
    }

    public ServiceLocator create(String name, ServiceLocator parent) {
        return this.create(name, parent, null);
    }

    public ServiceLocator create(String name, ServiceLocator parent, ServiceLocatorGenerator generator) {
        return this.create(name, parent, generator, ServiceLocatorFactory.CreatePolicy.RETURN);
    }

    public ServiceLocator create(String name, ServiceLocator parent, ServiceLocatorGenerator generator, ServiceLocatorFactory.CreatePolicy policy) {
        if (generator == null) {
            generator = this.generatorRef.get();
        }
        if (generator == null) {
            throw new IllegalStateException("There is no ServiceLocatorGenerator installed.");
        }
        return this.factory.create(name, parent, generator, policy);
    }

    public ServiceLocator find(String name) {
        return this.factory.find(name);
    }

    public void destroy(String name) {
        this.factory.destroy(name);
    }

    public void destroy(ServiceLocator locator) {
        this.factory.destroy(locator);
    }

    public void addListener(ServiceLocatorListener listener) {
        this.factory.addListener(listener);
    }

    public void removeListener(ServiceLocatorListener listener) {
        this.factory.removeListener(listener);
    }
}

