/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.MoreTypes;
import com.squarespace.jersey2.guice.BindingUtils;
import com.squarespace.jersey2.guice.GuiceBindingDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

class GuiceJustInTimeResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;
    private final Injector injector;

    public GuiceJustInTimeResolver(ServiceLocator locator, Injector injector) {
        this.locator = locator;
        this.injector = injector;
    }

    public boolean justInTimeResolution(Injectee injectee) {
        Binding<?> binding;
        Type type = injectee.getRequiredType();
        Class clazz = MoreTypes.getRawType((Type)type);
        if (clazz != null && (binding = this.findBinding(injectee)) != null) {
            Key key = binding.getKey();
            Set<Annotation> qualifiers = BindingUtils.getQualifiers(key);
            GuiceBindingDescriptor descriptor = new GuiceBindingDescriptor(type, clazz, qualifiers, binding);
            ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.locator, descriptor);
            return true;
        }
        return false;
    }

    private Binding<?> findBinding(Injectee injectee) {
        Key<?> key = BindingUtils.toKey(injectee);
        if (key == null) {
            return null;
        }
        if (BindingUtils.isHk2Contract(injectee)) {
            return null;
        }
        if (BindingUtils.isJerseyContract(injectee)) {
            return this.injector.getExistingBinding(key);
        }
        return this.injector.getBinding(key);
    }
}

