/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.Binding;
import com.squarespace.jersey2.guice.BindingUtils;
import com.squarespace.jersey2.guice.GuiceScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;

class GuiceBindingDescriptor<T>
extends AbstractActiveDescriptor<T> {
    private final Class<?> clazz;
    private final Binding<T> binding;

    public GuiceBindingDescriptor(Type type, Class<?> clazz, Set<Annotation> qualifiers, Binding<T> binding) {
        super(Collections.singleton(type), GuiceScope.class, BindingUtils.getNameFromAllQualifiers(qualifiers, clazz), qualifiers, DescriptorType.CLASS, DescriptorVisibility.NORMAL, 0, Boolean.valueOf(false), (Boolean)null, (String)null, Collections.emptyMap());
        this.clazz = clazz;
        this.binding = binding;
        this.setImplementation(clazz.getName());
    }

    public Class<?> getImplementationClass() {
        return this.clazz;
    }

    public T create(ServiceHandle<?> root) {
        return (T)this.binding.getProvider().get();
    }

    public boolean isReified() {
        return true;
    }

    public Set<Annotation> getQualifierAnnotations() {
        Set<Annotation> qualifierAnnotations = super.getQualifierAnnotations();
        return qualifierAnnotations.isEmpty() ? qualifierAnnotations : GuiceBindingDescriptor.lenientSet(qualifierAnnotations);
    }

    private static <E> Set<E> lenientSet(Collection<E> entries) {
        LenientHashSet<E> lenientHashSet = new LenientHashSet<E>();
        lenientHashSet.addAll(entries);
        return lenientHashSet;
    }

    private static class LenientHashSet<E>
    extends HashSet<E> {
        private LenientHashSet() {
        }

        @Override
        public boolean containsAll(Collection<?> foreignEntries) {
            for (Object foreignEntry : foreignEntries) {
                boolean matched = false;
                for (Object containedEntry : this) {
                    if (!containedEntry.equals(foreignEntry)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }
    }
}

