/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.squarespace.jersey2.guice.BindingUtils;
import com.squarespace.jersey2.guice.GuiceBindingDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

class GuiceBinder<T>
extends AbstractBinder {
    private final Key<T> key;
    private final Binding<T> binding;

    public GuiceBinder(Key<T> key, Binding<T> binding) {
        this.key = key;
        this.binding = binding;
    }

    protected void configure() {
        this.bind((Descriptor)GuiceBinder.newDescriptor(this.key, this.binding));
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiceBinder)) {
            return false;
        }
        GuiceBinder other = (GuiceBinder)((Object)o);
        return this.key.equals(other.key);
    }

    public String toString() {
        return this.key.toString();
    }

    private static <T> GuiceBindingDescriptor<T> newDescriptor(Key<T> key, Binding<T> binding) {
        TypeLiteral typeLiteral = key.getTypeLiteral();
        Type type = typeLiteral.getType();
        Class clazz = typeLiteral.getRawType();
        Set<Annotation> qualifiers = BindingUtils.getQualifiers(key);
        return new GuiceBindingDescriptor<T>(type, clazz, qualifiers, binding);
    }
}

