/*
 * Decompiled with CFR 0.152.
 */
package com.squarespace.jersey2.guice;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.internal.Nullability;
import com.google.inject.name.Named;
import com.squarespace.jersey2.guice.GuiceInjectionResolver;
import com.squarespace.jersey2.guice.GuiceQualifier;
import com.squarespace.jersey2.guice.GuiceThreeThirtyResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.jersey.spi.Contract;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;

class BindingUtils {
    private BindingUtils() {
    }

    public static ActiveDescriptor<InjectionResolver<javax.inject.Inject>> newThreeThirtyInjectionResolverDescriptor(ServiceLocator locator) {
        GuiceThreeThirtyResolver resolver = new GuiceThreeThirtyResolver(locator);
        Set<NamedImpl> qualifiers = Collections.singleton(new NamedImpl("SystemInjectResolver"));
        return BindingUtils.newActiveDescriptor(locator, resolver, qualifiers, "SystemInjectResolver", javax.inject.Inject.class);
    }

    public static ActiveDescriptor<InjectionResolver<Inject>> newGuiceInjectionResolverDescriptor(ServiceLocator locator, ActiveDescriptor<? extends InjectionResolver<?>> threeThirtyResolver) {
        GuiceInjectionResolver resolver = new GuiceInjectionResolver(threeThirtyResolver);
        Set<Annotation> qualifiers = Collections.emptySet();
        return BindingUtils.newActiveDescriptor(locator, resolver, qualifiers, "GuiceInjectionResolver", Inject.class);
    }

    private static <T extends Annotation> ActiveDescriptor<InjectionResolver<T>> newActiveDescriptor(ServiceLocator locator, InjectionResolver<T> resolver, Set<Annotation> qualifiers, String name, Class<? extends T> clazz) {
        Set<ParameterizedTypeImpl> contracts = Collections.singleton(new ParameterizedTypeImpl(InjectionResolver.class, new Type[]{clazz}));
        ConstantActiveDescriptor descriptor = new ConstantActiveDescriptor(resolver, contracts, Singleton.class, name, qualifiers, DescriptorVisibility.NORMAL, 0, (Boolean)null, (Boolean)null, (String)null, locator.getLocatorId(), (Map)null);
        return descriptor;
    }

    public static boolean isNullable(Injectee injectee) {
        if (injectee.isOptional()) {
            return true;
        }
        AnnotatedElement element = injectee.getParent();
        if (BindingUtils.isGuiceOptional(element)) {
            return true;
        }
        int position = injectee.getPosition();
        if (element instanceof Field) {
            return Nullability.allowsNull((Annotation[])((Field)element).getAnnotations());
        }
        if (element instanceof Method) {
            Annotation[][] annotations = ((Method)element).getParameterAnnotations();
            return Nullability.allowsNull((Annotation[])annotations[position]);
        }
        if (element instanceof Constructor) {
            Annotation[][] annotations = ((Constructor)element).getParameterAnnotations();
            return Nullability.allowsNull((Annotation[])annotations[position]);
        }
        return false;
    }

    private static boolean isGuiceOptional(AnnotatedElement element) {
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            return inject.optional();
        }
        return false;
    }

    public static boolean isHk2Contract(Injectee injectee) {
        Type type = injectee.getRequiredType();
        return BindingUtils.isContact(type, org.jvnet.hk2.annotations.Contract.class);
    }

    public static boolean isJerseyContract(Injectee injectee) {
        Type type = injectee.getRequiredType();
        return BindingUtils.isContact(type, Contract.class);
    }

    private static boolean isContact(Type type, Class<? extends Annotation> annotationType) {
        if (type instanceof Class) {
            return ((Class)type).isAnnotationPresent(annotationType);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return BindingUtils.isContact(rawType, annotationType);
        }
        return false;
    }

    public static javax.inject.Named toThreeThirtyNamed(Named qualifier) {
        return new NamedImpl(qualifier.value());
    }

    public static Key<?> toKey(Injectee injectee) {
        Type type = injectee.getRequiredType();
        Set<Annotation> qualifiers = BindingUtils.getQualifiers(injectee);
        return BindingUtils.newKey(type, qualifiers);
    }

    public static <T> Set<Annotation> getQualifiers(Key<T> key) {
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            Class<? extends Annotation> type;
            if (annotation instanceof Named) {
                annotation = BindingUtils.toThreeThirtyNamed((Named)annotation);
            }
            if ((type = annotation.annotationType()).isAnnotationPresent(Qualifier.class)) {
                return Collections.singleton(annotation);
            }
            return Collections.singleton(new GuiceQualifier<T>(key));
        }
        Class annotationType = key.getAnnotationType();
        if (annotationType != null) {
            return Collections.singleton(new GuiceQualifier<T>(key));
        }
        return Collections.emptySet();
    }

    private static Key<?> newKey(Type type, Set<? extends Annotation> qualifiers) {
        Iterator<? extends Annotation> iterator;
        if (qualifiers.isEmpty()) {
            return Key.get((Type)type);
        }
        if (qualifiers.size() == 1 && (iterator = qualifiers.iterator()).hasNext()) {
            Annotation first = iterator.next();
            return Key.get((Type)type, (Annotation)first);
        }
        return null;
    }

    private static Set<Annotation> getQualifiers(Injectee injectee) {
        int position;
        Set qualifiers = injectee.getRequiredQualifiers();
        if (!qualifiers.isEmpty()) {
            return qualifiers;
        }
        AnnotatedElement element = injectee.getParent();
        Annotation annotation = BindingUtils.getBindingAnnotation(element, position = injectee.getPosition());
        if (annotation != null) {
            return Collections.singleton(annotation);
        }
        return Collections.emptySet();
    }

    private static Annotation getBindingAnnotation(AnnotatedElement element, int position) {
        if (element instanceof Field) {
            return BindingUtils.getBindingAnnotation(((Field)element).getAnnotations());
        }
        if (element instanceof Method) {
            Annotation[][] annotations = ((Method)element).getParameterAnnotations();
            return BindingUtils.getBindingAnnotation(annotations[position]);
        }
        if (element instanceof Constructor) {
            Annotation[][] annotations = ((Constructor)element).getParameterAnnotations();
            return BindingUtils.getBindingAnnotation(annotations[position]);
        }
        return null;
    }

    private static Annotation getBindingAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!type.isAnnotationPresent(BindingAnnotation.class)) continue;
            return annotation;
        }
        return null;
    }

    public static String getNameFromAllQualifiers(Set<Annotation> qualifiers, AnnotatedElement element) {
        return ReflectionHelper.getNameFromAllQualifiers(qualifiers, (AnnotatedElement)element);
    }
}

