/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.collect.ImmutableList;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import java.util.Collection;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsAnything;

public class IsJsonArray
extends AbstractJsonNodeMatcher<ArrayNode> {
    private final Matcher<? super Collection<JsonNode>> elementsMatcher;

    private IsJsonArray(Matcher<? super Collection<JsonNode>> elementsMatcher) {
        super(JsonNodeType.ARRAY);
        this.elementsMatcher = Objects.requireNonNull(elementsMatcher);
    }

    public static Matcher<JsonNode> jsonArray() {
        return new IsJsonArray((Matcher<? super Collection<JsonNode>>)Matchers.is((Matcher)IsAnything.anything()));
    }

    public static Matcher<JsonNode> jsonArray(Matcher<? super Collection<? extends JsonNode>> elementsMatcher) {
        return new IsJsonArray(elementsMatcher);
    }

    public static Matcher<JsonNode> jsonArray(ArrayNode value) {
        return IsJsonArray.jsonArray((Matcher<? super Collection<? extends JsonNode>>)Matchers.is((Object)ImmutableList.copyOf((Iterable)value)));
    }

    @Override
    protected boolean matchesNode(ArrayNode node, Description mismatchDescription) {
        ImmutableList elements = ImmutableList.copyOf((Iterable)node);
        if (this.elementsMatcher.matches((Object)elements)) {
            return true;
        }
        mismatchDescription.appendText("was an array node whose elements ");
        this.elementsMatcher.describeMismatch((Object)elements, mismatchDescription);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("an array node whose elements ").appendDescriptionOf(this.elementsMatcher);
    }
}

