/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.StringWrapper;
import com.spotify.fmt.FormatterException;
import com.spotify.fmt.FormattingConfiguration;
import com.spotify.fmt.FormattingResult;
import com.spotify.fmt.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

class Formatter {
    private static final Log log = Logging.getLog();
    private final FormattingConfiguration cfg;
    private final CopyOnWriteArrayList<String> processedFiles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> nonComplyingFiles = new CopyOnWriteArrayList();

    Formatter(FormattingConfiguration cfg) {
        this.cfg = cfg;
    }

    FormattingResult format() throws FormatterException {
        JavaFormatterOptions.Style style = this.style();
        com.google.googlejavaformat.java.Formatter formatter = this.getFormatter(style);
        for (File directoryToFormat : this.cfg.directoriesToFormat()) {
            this.formatSourceFilesInDirectory(directoryToFormat, formatter, style);
        }
        this.logNumberOfFilesProcessed();
        return FormattingResult.builder().nonComplyingFiles((List<? extends String>)this.nonComplyingFiles).processedFiles((List<? extends String>)this.processedFiles).build();
    }

    public void formatSourceFilesInDirectory(File directory, com.google.googlejavaformat.java.Formatter formatter, JavaFormatterOptions.Style style) throws FormatterException {
        if (!directory.isDirectory()) {
            log.info((CharSequence)("Directory '" + String.valueOf(directory) + "' is not a directory. Skipping."));
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(directory.getPath(), new String[0]), new FileVisitOption[0]);){
            FileFilter fileNameFilter = this.getFileNameFilter();
            FileFilter pathFilter = this.getPathFilter();
            long failures = paths.collect(Collectors.toList()).parallelStream().filter(p -> p.toFile().exists()).map(Path::toFile).filter(fileNameFilter::accept).filter(pathFilter::accept).map(file -> this.formatSourceFile((File)file, formatter, style)).filter(r -> r == false).count();
            if (failures > 0L) {
                throw new FormatterException("There were errors when formatting files. Error count: " + failures);
            }
        }
        catch (IOException exception) {
            throw new FormatterException(exception.getMessage());
        }
    }

    private com.google.googlejavaformat.java.Formatter getFormatter(JavaFormatterOptions.Style style) {
        return new com.google.googlejavaformat.java.Formatter(JavaFormatterOptions.builder().style(style).build());
    }

    private JavaFormatterOptions.Style style() throws FormatterException {
        if ("aosp".equalsIgnoreCase(this.cfg.style())) {
            log.debug((CharSequence)"Using AOSP style");
            return JavaFormatterOptions.Style.AOSP;
        }
        if ("google".equalsIgnoreCase(this.cfg.style())) {
            log.debug((CharSequence)"Using Google style");
            return JavaFormatterOptions.Style.GOOGLE;
        }
        String message = "Unknown style '" + this.cfg.style() + "'. Expected 'google' or 'aosp'.";
        log.error((CharSequence)message);
        throw new FormatterException(message);
    }

    private FileFilter getFileNameFilter() {
        if (this.cfg.verbose()) {
            log.debug((CharSequence)("Filter files on '" + this.cfg.filesNamePattern() + "'."));
        }
        return pathname -> pathname.isDirectory() || pathname.getName().matches(this.cfg.filesNamePattern());
    }

    private FileFilter getPathFilter() {
        if (this.cfg.verbose()) {
            log.debug((CharSequence)("Filter paths on '" + this.cfg.filesPathPattern() + "'."));
        }
        return pathname -> pathname.isDirectory() || pathname.getPath().matches(this.cfg.filesPathPattern());
    }

    private boolean formatSourceFile(File file, com.google.googlejavaformat.java.Formatter formatter, JavaFormatterOptions.Style style) {
        if (file.isDirectory()) {
            if (this.cfg.verbose()) {
                log.debug((CharSequence)("File '" + String.valueOf(file) + "' is a directory. Skipping."));
            }
            return true;
        }
        if (this.cfg.verbose()) {
            log.debug((CharSequence)("Formatting '" + String.valueOf(file) + "'."));
        }
        CharSource source = com.google.common.io.Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        try {
            String input = source.read();
            String formatted = formatter.formatSource(input);
            if (!this.cfg.skipRemovingUnusedImports()) {
                formatted = RemoveUnusedImports.removeUnusedImports((String)formatted);
            }
            if (!this.cfg.skipSortingImports()) {
                formatted = ImportOrderer.reorderImports((String)formatted, (JavaFormatterOptions.Style)style);
            }
            if (!this.cfg.skipReflowingLongStrings()) {
                formatted = StringWrapper.wrap((String)formatted, (com.google.googlejavaformat.java.Formatter)formatter);
            }
            if (!input.equals(formatted)) {
                if (this.cfg.writeReformattedFiles()) {
                    CharSink sink = com.google.common.io.Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
                    sink.write((CharSequence)formatted);
                }
                this.nonComplyingFiles.add(file.getAbsolutePath());
            }
            this.processedFiles.add(file.getAbsolutePath());
            if (this.processedFiles.size() % 100 == 0) {
                this.logNumberOfFilesProcessed();
            }
        }
        catch (com.google.googlejavaformat.java.FormatterException | IOException e) {
            log.error((CharSequence)("Failed to format file '" + String.valueOf(file) + "'."), e);
            return false;
        }
        return true;
    }

    protected void logNumberOfFilesProcessed() {
        log.info((CharSequence)String.format("Processed %d files (%d %s).", this.processedFiles.size(), this.nonComplyingFiles.size(), this.cfg.processingLabel()));
    }
}

