/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.stage;

import java.util.Objects;

public enum JoinType {
    INNER_JOIN("INNER JOIN", false, false),
    LEFT_JOIN("LEFT JOIN", true, false),
    RIGHT_JOIN("RIGHT JOIN", false, true),
    CROSS_JOIN("CROSS JOIN", false, false);

    private final String sql;
    private final boolean nullableSelf;
    private final boolean nullableOther;

    private JoinType(String sql, boolean nullableSelf, boolean nullableOther) {
        this.sql = Objects.requireNonNull(sql);
        this.nullableSelf = nullableSelf;
        this.nullableOther = nullableOther;
    }

    public String sql() {
        return this.sql;
    }

    public boolean isNullableSelf() {
        return this.nullableSelf;
    }

    public boolean isNullableOther() {
        return this.nullableOther;
    }

    public boolean isNeverNullable() {
        return !this.nullableSelf && !this.nullableOther;
    }
}

