/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.stage;

import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.join.stage.JoinOperator;
import com.speedment.runtime.join.stage.JoinType;
import com.speedment.runtime.join.stage.Stage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StageImpl<T>
implements Stage<T> {
    private final TableIdentifier<T> identifier;
    private final List<Predicate<? super T>> predicates;
    private final JoinType joinType;
    private final HasComparableOperators<T, ?> field;
    private final JoinOperator joinOperator;
    private final HasComparableOperators<?, ?> foreignFirstField;
    private final int referencedStage;

    public StageImpl(TableIdentifier<T> identifier, List<Predicate<? super T>> predicates, JoinType joinType, HasComparableOperators<T, ?> field, JoinOperator joinOperator, HasComparableOperators<?, ?> foreignField, int referencedStage) {
        this.identifier = Objects.requireNonNull(identifier);
        this.predicates = predicates;
        this.joinType = joinType;
        this.field = field;
        this.joinOperator = joinOperator;
        this.foreignFirstField = foreignField;
        this.referencedStage = referencedStage;
    }

    @Override
    public TableIdentifier<T> identifier() {
        return this.identifier;
    }

    @Override
    public List<Predicate<? super T>> predicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    @Override
    public Optional<JoinType> joinType() {
        return Optional.ofNullable(this.joinType);
    }

    @Override
    public Optional<HasComparableOperators<T, ?>> field() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public Optional<JoinOperator> joinOperator() {
        return Optional.ofNullable(this.joinOperator);
    }

    @Override
    public Optional<HasComparableOperators<?, ?>> foreignField() {
        return Optional.ofNullable(this.foreignFirstField);
    }

    @Override
    public int referencedStage() {
        return this.referencedStage;
    }

    public String toString() {
        return "StageImpl{identifier=" + this.identifier + ", predicates=" + this.predicates + ", joinType=" + (Object)((Object)this.joinType) + ", field=" + this.field + ", joinOperator=" + (Object)((Object)this.joinOperator) + ", foreignFirstField=" + this.foreignFirstField + ", referencedStage=" + this.referencedStage + '}';
    }
}

