/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.stream.sql;

import com.speedment.common.invariant.IntRangeUtil;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.join.internal.component.stream.sql.JoinSqlUtil;
import com.speedment.runtime.join.internal.component.stream.sql.SqlInfo;
import com.speedment.runtime.join.stage.Stage;
import java.util.Objects;
import java.util.stream.Collectors;

final class SqlStage {
    private final Stage<?> stage;
    private final int stageIndex;
    private final Table table;
    private final String sqlColumnList;
    private final String sqlTableReference;

    SqlStage(SqlInfo info, Stage<?> stage, int stageIndex) {
        Objects.requireNonNull(info);
        this.stage = Objects.requireNonNull(stage);
        this.stageIndex = IntRangeUtil.requireNonNegative((int)stageIndex);
        this.table = DocumentDbUtil.referencedTable((Project)info.project(), stage.identifier());
        String tableAlias = JoinSqlUtil.tableAlias(stageIndex);
        this.sqlColumnList = this.table.columns().filter(HasEnabled::isEnabled).map(HasName::getName).map(n -> tableAlias + "." + info.namingConvention().encloseField(n)).collect(Collectors.joining(","));
        this.sqlTableReference = info.namingConvention().fullNameOf(this.table) + (DbmsType.SubSelectAlias.PROHIBITED.equals((Object)info.dbmsType().getSubSelectAlias()) ? " " : " AS ") + tableAlias;
    }

    Stage<?> stage() {
        return this.stage;
    }

    int stageIndex() {
        return this.stageIndex;
    }

    Table table() {
        return this.table;
    }

    String sqlColumnList() {
        return this.sqlColumnList;
    }

    String sqlTableReference() {
        return this.sqlTableReference;
    }
}

