/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.stream.sql;

import com.speedment.common.invariant.IntRangeUtil;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.SqlAdapter;
import com.speedment.runtime.core.db.AsynchronousQueryResult;
import com.speedment.runtime.core.db.DatabaseNamingConvention;
import com.speedment.runtime.core.db.SqlFunction;
import com.speedment.runtime.core.db.SqlPredicateFragment;
import com.speedment.runtime.core.stream.parallel.ParallelStrategy;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.predicate.CombinedPredicate;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.join.internal.component.stream.SqlAdapterMapper;
import com.speedment.runtime.join.internal.component.stream.sql.InitialJoinStream;
import com.speedment.runtime.join.internal.component.stream.sql.SqlInfo;
import com.speedment.runtime.join.internal.component.stream.sql.SqlStage;
import com.speedment.runtime.join.stage.JoinOperator;
import com.speedment.runtime.join.stage.JoinType;
import com.speedment.runtime.join.stage.Stage;
import com.speedment.runtime.typemapper.TypeMapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class JoinSqlUtil {
    private static final String[] ALIASES = (String[])IntStream.range(0, 10).mapToObj(i -> Character.toString((char)(65 + i))).toArray(String[]::new);

    private JoinSqlUtil() {
    }

    static Dbms requireSameDbms(Project project, List<Stage<?>> stages) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(stages);
        Dbms dbms = DocumentDbUtil.referencedDbms((Project)project, stages.get(0).identifier());
        ArrayList<Dbms> failingDbmses = new ArrayList<Dbms>();
        for (int i = 1; i < stages.size(); ++i) {
            Dbms otherDbms = DocumentDbUtil.referencedDbms((Project)project, stages.get(i).identifier());
            if (DocumentDbUtil.isSame((Dbms)dbms, (Dbms)otherDbms)) continue;
            failingDbmses.add(otherDbms);
        }
        if (!failingDbmses.isEmpty()) {
            throw new IllegalStateException("The first database in this join is " + dbms.toString() + " but there are other databases in the same join which is illegal: " + ((Object)failingDbmses).toString());
        }
        return dbms;
    }

    static <T> SqlFunction<ResultSet, T> resultSetMapper(Project project, TableIdentifier<T> identifier, List<Stage<?>> stages, int stageIndex, SqlAdapterMapper sqlAdapterMapper) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(stages);
        IntRangeUtil.requireNonNegative((int)stageIndex);
        Objects.requireNonNull(sqlAdapterMapper);
        Stage<?> stage = stages.get(stageIndex);
        int offset = 0;
        for (int i = 0; i < stageIndex; ++i) {
            Stage<?> otherStage = stages.get(i);
            Table table = DocumentDbUtil.referencedTable((Project)project, otherStage.identifier());
            offset = (int)((long)offset + table.columns().filter(HasEnabled::isEnabled).count());
        }
        Table table = DocumentDbUtil.referencedTable((Project)project, stage.identifier());
        int nullOffset = -1;
        if (stage.joinType().isPresent() && stage.joinType().orElseThrow(() -> JoinSqlUtil.newNoSuchElementException(stage)).isNullableSelf()) {
            nullOffset = JoinSqlUtil.findNullOffset(table, stage, stage.field().orElseThrow(() -> new NoSuchElementException("field is missing in stage" + stage)));
        }
        if (nullOffset == -1) {
            TableIdentifier<?> thisId = stage.identifier();
            for (int i = 0; i < stages.size(); ++i) {
                HasComparableOperators<?, ?> otherStageForeignField;
                TableIdentifier referencedId;
                Stage<?> otherStage;
                if (stageIndex == i || !(otherStage = stages.get(i)).joinType().isPresent() || !otherStage.joinType().orElseThrow(() -> JoinSqlUtil.newNoSuchElementException(otherStage)).isNullableOther() || !thisId.equals((Object)(referencedId = (otherStageForeignField = otherStage.foreignField().orElseThrow(() -> new NoSuchElementException("Foreign fiels is missing in other stage " + otherStage))).identifier().asTableIdentifier()))) continue;
                nullOffset = JoinSqlUtil.findNullOffset(table, otherStage, otherStageForeignField);
            }
        }
        if (nullOffset >= 0) {
            return new NullAwareSqlAdapter(sqlAdapterMapper.apply(identifier), nullOffset).entityMapper(offset);
        }
        return sqlAdapterMapper.apply(identifier).entityMapper(offset);
    }

    private static int findNullOffset(Table table, Stage<?> stage, HasComparableOperators<?, ?> field) {
        int result = -1;
        String onColumnId = field.identifier().getColumnId();
        List columns = table.columns().filter(HasEnabled::isEnabled).collect(Collectors.toList());
        for (int j = 0; j < columns.size(); ++j) {
            String columnId = ((Column)columns.get(j)).getId();
            if (!columnId.equals(onColumnId)) continue;
            result = j;
            break;
        }
        if (result == -1) {
            throw new IllegalStateException("Unable to locate column " + onColumnId + " in table " + table.getId() + " for stage " + stage.toString() + " Columns: " + columns.stream().map(HasId::getId).collect(Collectors.joining(", ")));
        }
        return result;
    }

    static <T> Stream<T> stream(DbmsHandlerComponent dbmsHandlerComponent, Project project, List<Stage<?>> stages, SqlFunction<ResultSet, T> rsMapper, boolean allowStreamIteratorAndSpliterator) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(dbmsHandlerComponent);
        Objects.requireNonNull(stages);
        Objects.requireNonNull(rsMapper);
        SqlInfo sqlInfo = new SqlInfo(dbmsHandlerComponent, project, stages);
        List<SqlStage> sqlStages = sqlInfo.sqlStages();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(sqlStages.stream().map(SqlStage::sqlColumnList).collect(Collectors.joining(", ")));
        SqlStage firstSqlStage = sqlStages.get(0);
        sb.append(" FROM ").append(firstSqlStage.sqlTableReference()).append(" ");
        for (int i = 1; i < sqlStages.size(); ++i) {
            String joinSql = JoinSqlUtil.renderJoin(sqlInfo.namingConvention(), sqlStages, stages, i);
            sb.append(joinSql);
        }
        StringBuilder predicateSql = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        JoinSqlUtil.renderPredicates(sqlInfo, stages, predicateSql, values);
        if (predicateSql.length() > 0) {
            sb.append(" WHERE ").append((CharSequence)predicateSql);
        }
        String sql = sb.toString();
        AsynchronousQueryResult asynchronousQueryResult = sqlInfo.dbmsType().getOperationHandler().executeQueryAsync(sqlInfo.dbms(), sql, values, rsMapper, ParallelStrategy.computeIntensityDefault());
        return new InitialJoinStream(asynchronousQueryResult, sqlInfo, allowStreamIteratorAndSpliterator);
    }

    static String tableAlias(int index) {
        return ALIASES[index];
    }

    private static void renderPredicates(SqlInfo sqlInfo, List<Stage<?>> stages, StringBuilder sql, List<Object> values) {
        Objects.requireNonNull(sqlInfo);
        Objects.requireNonNull(stages);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(values);
        int cnt = 0;
        for (int stageIndex = 0; stageIndex < stages.size(); ++stageIndex) {
            Stage<?> stage = stages.get(stageIndex);
            if (stage.predicates().isEmpty()) continue;
            for (int j = 0; j < stage.predicates().size(); ++j) {
                Predicate<?> predicate = stage.predicates().get(j);
                if (predicate instanceof FieldPredicate && ((FieldPredicate)predicate).getPredicateType() == PredicateType.ALWAYS_TRUE) continue;
                if (cnt++ != 0) {
                    sql.append(" AND ");
                }
                JoinSqlUtil.renderPredicateHelper(sqlInfo, stage, stageIndex, sql, values, predicate);
            }
        }
    }

    private static <ENTITY> void renderPredicateHelper(SqlInfo sqlInfo, Stage<?> stage, int stageIndex, StringBuilder sql, List<Object> values, Predicate<ENTITY> predicate) {
        Objects.requireNonNull(sqlInfo);
        Objects.requireNonNull(stage);
        IntRangeUtil.requireNonNegative((int)stageIndex);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(values);
        Objects.requireNonNull(predicate);
        if (predicate instanceof FieldPredicate) {
            FieldPredicate fieldPredicate = (FieldPredicate)predicate;
            SqlPredicateFragment fragment = sqlInfo.fieldPredicateView().transform(f -> JoinSqlUtil.tableAlias(stageIndex) + "." + sqlInfo.namingConvention().encloseField(f.identifier().getColumnId()), f -> ((Column)f.findColumn(sqlInfo.project()).get()).findDatabaseType(), fieldPredicate);
            Field referenceFieldTrait = fieldPredicate.getField();
            TypeMapper tm = referenceFieldTrait.typeMapper();
            sql.append(fragment.getSql());
            fragment.objects().map(arg_0 -> ((TypeMapper)tm).toDatabaseType(arg_0)).forEachOrdered(values::add);
        } else if (predicate instanceof CombinedPredicate) {
            CombinedPredicate combinedPredicate = (CombinedPredicate)predicate;
            StringBuilder internalSql = new StringBuilder();
            ArrayList internalValues = new ArrayList();
            AtomicInteger cnt = new AtomicInteger();
            combinedPredicate.stream().forEachOrdered(internalPredicate -> {
                if (cnt.getAndIncrement() != 0) {
                    internalSql.append(" ").append(combinedPredicate.getType().toString()).append(" ");
                }
                Predicate castedInternalPredicate = internalPredicate;
                JoinSqlUtil.renderPredicateHelper(sqlInfo, stage, stageIndex, internalSql, internalValues, castedInternalPredicate);
            });
            sql.append("(").append((CharSequence)internalSql).append(")");
            values.addAll(internalValues);
        } else {
            throw new IllegalArgumentException("A predicate that is nether an instanceof FieldPredicate nor CombinedPredicate was given:" + predicate.toString());
        }
    }

    private static String renderJoin(DatabaseNamingConvention naming, List<SqlStage> sqlStages, List<Stage<?>> stages, int stageIndex) {
        Objects.requireNonNull(naming);
        Objects.requireNonNull(sqlStages);
        IntRangeUtil.requireNonNegative((int)stageIndex);
        Stage<?> stage = stages.get(stageIndex);
        return JoinSqlUtil.renderJoin(naming, sqlStages, stages, stageIndex, stage.joinType().orElseThrow(() -> JoinSqlUtil.newNoSuchElementException(stage)));
    }

    private static String renderJoin(DatabaseNamingConvention naming, List<SqlStage> sqlStages, List<Stage<?>> stages, int stageIndex, JoinType joinType) {
        Objects.requireNonNull(naming);
        Objects.requireNonNull(sqlStages);
        IntRangeUtil.requireNonNegative((int)stageIndex);
        SqlStage sqlStage = sqlStages.get(stageIndex);
        Stage<?> stage = sqlStage.stage();
        StringBuilder sb = new StringBuilder();
        switch (joinType) {
            case CROSS_JOIN: {
                sb.append(", ").append(sqlStage.sqlTableReference()).append(" ");
                break;
            }
            default: {
                sb.append(joinType.sql()).append(" ");
                sb.append(sqlStage.sqlTableReference()).append(" ");
                stage.field().ifPresent(field -> {
                    HasComparableOperators<?, ?> foreignFirstField = stage.foreignField().get();
                    int foreignStageIndex = stage.referencedStage();
                    sb.append("ON (");
                    JoinOperator joinOperator = stage.joinOperator().get();
                    JoinSqlUtil.renderPredicate(sb, naming, stageIndex, foreignStageIndex, field, foreignFirstField, joinOperator.sqlOperator());
                    sb.append(") ");
                });
            }
        }
        return sb.toString();
    }

    private static void renderPredicate(StringBuilder sb, DatabaseNamingConvention naming, int stageIndex, int foreignStageIndex, HasComparableOperators<?, ?> field, HasComparableOperators<?, ?> foreignField, String operator) {
        sb.append(JoinSqlUtil.tableAlias(stageIndex)).append(".").append(naming.encloseField(field.identifier().getColumnId())).append(" ").append(operator).append(" ").append(JoinSqlUtil.tableAlias(foreignStageIndex)).append(".").append(naming.encloseField(foreignField.identifier().getColumnId()));
    }

    private static NoSuchElementException newNoSuchElementException(Stage<?> stage) {
        return new NoSuchElementException("Stage " + stage + " did not have a join type");
    }

    private static class NullAwareSqlAdapter<ENTITY>
    implements SqlAdapter<ENTITY> {
        private final SqlAdapter<ENTITY> inner;
        private final int nullableColumnOffset;

        private NullAwareSqlAdapter(SqlAdapter<ENTITY> inner, int nullableColumnOffset) {
            this.inner = Objects.requireNonNull(inner);
            this.nullableColumnOffset = IntRangeUtil.requireNonNegative((int)nullableColumnOffset);
        }

        public TableIdentifier<ENTITY> identifier() {
            return this.inner.identifier();
        }

        public SqlFunction<ResultSet, ENTITY> entityMapper() {
            return this.entityMapper(0);
        }

        public SqlFunction<ResultSet, ENTITY> entityMapper(int offset) {
            return rs -> {
                Object value = rs.getObject(1 + offset + this.nullableColumnOffset);
                if (value == null || rs.wasNull()) {
                    return null;
                }
                return this.inner.entityMapper(offset).apply(rs);
            };
        }
    }
}

