/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.stream.sql;

import com.speedment.common.invariant.LongRangeUtil;
import com.speedment.runtime.core.db.AsynchronousQueryResult;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.stream.AutoClosingStream;
import com.speedment.runtime.core.stream.ComposeRunnableUtil;
import com.speedment.runtime.join.internal.component.stream.sql.SqlInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class InitialJoinStream<T>
implements Stream<T> {
    private final AsynchronousQueryResult<T> asynchronousQueryResult;
    private final SqlInfo sqlInfo;
    private final boolean allowStreamIteratorAndSpliterator;
    private boolean parallel;
    private boolean unordered;
    private boolean consumed;
    private List<Runnable> closeHandlers;
    private long skip;
    private long limit;

    InitialJoinStream(AsynchronousQueryResult<T> asynchronousQueryResult, SqlInfo sqlInfo, boolean allowStreamIteratorAndSpliterator) {
        this.asynchronousQueryResult = Objects.requireNonNull(asynchronousQueryResult);
        this.sqlInfo = Objects.requireNonNull(sqlInfo);
        this.allowStreamIteratorAndSpliterator = allowStreamIteratorAndSpliterator;
        this.closeHandlers = new ArrayList<Runnable>();
        this.skip = 0L;
        this.limit = Long.MAX_VALUE;
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.materialize().filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.materialize().flatMapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.materialize().distinct();
    }

    @Override
    public Stream<T> sorted() {
        return this.materialize().sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.materialize().sorted(comparator);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        return this.materialize().peek(action);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        LongRangeUtil.requireNonNegative((long)maxSize);
        this.limit = Math.min(this.limit, maxSize);
        return this;
    }

    @Override
    public Stream<T> skip(long n) {
        LongRangeUtil.requireNonNegative((long)n);
        if (n == 0L) {
            return this;
        }
        this.skip += n;
        return this;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.materialize().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.materialize().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.materialize().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        Objects.requireNonNull(generator);
        return this.materialize().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.materialize().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.materialize().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return this.materialize().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return this.materialize().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        Objects.requireNonNull(collector);
        return this.materialize().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.materialize().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.materialize().max(comparator);
    }

    @Override
    public long count() {
        return this.materialize().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.materialize().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.materialize().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.materialize().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        this.limit(1L);
        return this.materialize().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        this.limit(1L);
        return this.materialize().findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.materialize().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.materialize().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public Stream<T> sequential() {
        this.parallel = false;
        return this;
    }

    @Override
    public Stream<T> parallel() {
        this.parallel = true;
        return this;
    }

    @Override
    public Stream<T> unordered() {
        this.unordered = true;
        return this;
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        Objects.requireNonNull(closeHandler);
        this.closeHandlers.add(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.consumed = true;
        try {
            ComposeRunnableUtil.composedRunnable(this.closeHandlers);
        }
        finally {
            this.asynchronousQueryResult.close();
        }
    }

    private Stream<T> materialize() {
        boolean skipLimitInSql;
        this.assertNotConsumed();
        this.consumed = true;
        boolean bl = skipLimitInSql = this.sqlInfo.dbmsType().getSkipLimitSupport() == DbmsType.SkipLimitSupport.STANDARD;
        if (skipLimitInSql) {
            List values = this.asynchronousQueryResult.getValues();
            String newSql = this.sqlInfo.dbmsType().applySkipLimit(this.asynchronousQueryResult.getSql(), values, this.skip, this.limit);
            this.asynchronousQueryResult.setSql(newSql);
        }
        Stream result = (Stream)AutoClosingStream.of((Stream)this.asynchronousQueryResult.stream(), (boolean)this.allowStreamIteratorAndSpliterator).onClose(this::close);
        if (this.parallel) {
            result = (Stream)result.parallel();
        }
        if (this.unordered) {
            result = (Stream)result.unordered();
        }
        if (!skipLimitInSql) {
            if (this.skip > 0L) {
                result = result.skip(this.skip);
            }
            if (this.limit < Long.MAX_VALUE) {
                result = result.limit(this.limit);
            }
        }
        return result;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("This stream has already been consumed");
        }
    }
}

