/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.stream.sql;

import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.db.SqlFunction;
import com.speedment.runtime.join.Join;
import com.speedment.runtime.join.internal.JoinImpl;
import com.speedment.runtime.join.internal.component.stream.SqlAdapterMapper;
import com.speedment.runtime.join.internal.component.stream.sql.JoinSqlUtil;
import com.speedment.runtime.join.stage.Stage;
import java.sql.ResultSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractSqlHasCreateJoin {
    private final DbmsHandlerComponent dbmsHandlerComponent;
    private final Project project;
    private final SqlAdapterMapper sqlAdapterMapper;
    private final boolean allowStreamIteratorAndSpliterator;

    AbstractSqlHasCreateJoin(DbmsHandlerComponent dbmsHandlerComponent, Project project, SqlAdapterMapper sqlAdapterMapper, boolean allowStreamIteratorAndSpliterator) {
        this.dbmsHandlerComponent = Objects.requireNonNull(dbmsHandlerComponent);
        this.project = Objects.requireNonNull(project);
        this.sqlAdapterMapper = Objects.requireNonNull(sqlAdapterMapper);
        this.allowStreamIteratorAndSpliterator = allowStreamIteratorAndSpliterator;
    }

    <T> SqlFunction<ResultSet, T> rsMapper(List<Stage<?>> stages, int stageIndex, TableIdentifier<T> identifier) {
        return JoinSqlUtil.resultSetMapper(this.project, identifier, stages, stageIndex, this.sqlAdapterMapper);
    }

    <T> Join<T> newJoin(List<Stage<?>> stages, SqlFunction<ResultSet, T> rsMapper) {
        Objects.requireNonNull(stages);
        Objects.requireNonNull(rsMapper);
        return new JoinImpl(() -> JoinSqlUtil.stream(this.dbmsHandlerComponent, this.project, stages, rsMapper, this.allowStreamIteratorAndSpliterator));
    }
}

