/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.join;

import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.join.stage.JoinOperator;
import com.speedment.runtime.join.stage.JoinType;
import com.speedment.runtime.join.stage.Stage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

final class StageBean<T> {
    private final TableIdentifier<T> identifier;
    private final List<Predicate<? super T>> predicates;
    private JoinType joinType;
    private HasComparableOperators<T, ?> field;
    private JoinOperator joinOperator;
    private HasComparableOperators<?, ?> foreignField;
    private int referencedStage;

    StageBean(TableIdentifier<T> identifier) {
        this.identifier = Objects.requireNonNull(identifier);
        this.predicates = new ArrayList<Predicate<? super T>>();
    }

    StageBean(TableIdentifier<T> identifier, JoinType joinType) {
        this.identifier = Objects.requireNonNull(identifier);
        this.predicates = new ArrayList<Predicate<? super T>>();
        this.joinType = Objects.requireNonNull(joinType);
    }

    StageBean(JoinType joinType, HasComparableOperators<T, ?> field) {
        Objects.requireNonNull(field);
        this.identifier = Objects.requireNonNull(field.identifier().asTableIdentifier());
        this.predicates = new ArrayList<Predicate<? super T>>();
        this.joinType = Objects.requireNonNull(joinType);
        this.field = field;
    }

    JoinType getJoinType() {
        return this.joinType;
    }

    void setJoinType(JoinType joinType) {
        this.joinType = Objects.requireNonNull(joinType);
    }

    HasComparableOperators<? extends T, ?> getField() {
        return this.field;
    }

    void setField(HasComparableOperators<T, ?> field) {
        this.field = Objects.requireNonNull(field);
    }

    JoinOperator getJoinOperator() {
        return this.joinOperator;
    }

    void setJoinOperator(JoinOperator joinOperator) {
        this.joinOperator = Objects.requireNonNull(joinOperator);
    }

    HasComparableOperators<?, ?> getForeignField() {
        return this.foreignField;
    }

    void setForeignField(HasComparableOperators<?, ?> foreignFirstField) {
        this.foreignField = Objects.requireNonNull(foreignFirstField);
    }

    int getReferencedStage() {
        return this.referencedStage;
    }

    void setReferencedStage(int referencedStage) {
        this.referencedStage = referencedStage;
    }

    TableIdentifier<T> getIdentifier() {
        return this.identifier;
    }

    List<Predicate<? super T>> getPredicates() {
        return this.predicates;
    }

    Stage<T> asStage() {
        return Stage.of(this.identifier, this.predicates, this.joinType, this.field, this.joinOperator, this.foreignField, this.referencedStage);
    }
}

