/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.terminal.standard.internal;

import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.AcceptTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyAsLongTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.TestTerminalOperation;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class InternalTerminalOperationFactory
implements TerminalOperationFactory {
    private static final TerminalOperation<Stream<Object>, Object[]> TO_ARRAY = new ApplyTerminalOperation<Stream, Object[], Function<Stream, Object[]>>(TerminalOperationType.TO_ARRAY, Stream.class, Object[].class, Stream::toArray, new Object[0]);
    private static final TerminalOperation<Stream<Object>, Optional<?>> FIND_FIRST = new ApplyTerminalOperation<Stream, Optional, Function<Stream, Optional>>(TerminalOperationType.FIND_FIRST, Stream.class, Optional.class, Stream::findFirst, new Object[0]);
    private static final TerminalOperation<Stream<Object>, Optional<?>> FIND_ANY = new ApplyTerminalOperation<Stream, Optional, Function<Stream, Optional>>(TerminalOperationType.FIND_ANY, Stream.class, Optional.class, Stream::findAny, new Object[0]);
    private static final TerminalOperation<Stream<Object>, Long> COUNT = new ApplyAsLongTerminalOperation<Stream, Long, ToLongFunction<Stream>>(TerminalOperationType.COUNT, Stream.class, Long.TYPE, Stream::count, new Object[0]);
    private static final TerminalOperation<Stream<Object>, Iterator<Object>> ITERATOR = new ApplyTerminalOperation<Stream, Iterator, Function<Stream, Iterator>>(TerminalOperationType.ITERATOR, Stream.class, Iterator.class, BaseStream::iterator, new Object[0]);
    private static final TerminalOperation<Stream<Object>, Spliterator<Object>> SPLITERATOR = new ApplyTerminalOperation<Stream, Spliterator, Function<Stream, Spliterator>>(TerminalOperationType.SPLITERATOR, Stream.class, Spliterator.class, BaseStream::spliterator, new Object[0]);

    public <T> TerminalOperation<Stream<T>, Void> createForEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<Stream, Void, Consumer<Stream>>(TerminalOperationType.FOR_EACH, Stream.class, Void.TYPE, stream -> stream.forEach(action), action);
    }

    public <T> TerminalOperation<Stream<T>, Void> createForEachOrdered(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<Stream, Void, Consumer<Stream>>(TerminalOperationType.FOR_EACH_ORDERED, Stream.class, Void.TYPE, stream -> stream.forEachOrdered(action), action);
    }

    public <T> TerminalOperation<Stream<T>, Object[]> acquireToArray() {
        return this.typed(TO_ARRAY);
    }

    public <T, A> TerminalOperation<Stream<T>, A[]> createToArray(IntFunction<A[]> generator) {
        Objects.requireNonNull(generator);
        return new ApplyTerminalOperation<Stream, Object[], Function<Stream, Object[]>>(TerminalOperationType.TO_ARRAY, Stream.class, Object[].class, stream -> stream.toArray(generator), generator);
    }

    public <T> TerminalOperation<Stream<T>, T> createReduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(accumulator);
        return new ApplyTerminalOperation<Stream, Object, Function<Stream, Object>>(TerminalOperationType.REDUCE, Stream.class, Object.class, stream -> stream.reduce(identity, accumulator), identity, accumulator);
    }

    public <T> TerminalOperation<Stream<T>, Optional<T>> createReduce(BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return new ApplyTerminalOperation<Stream, Optional, Function<Stream, Optional>>(TerminalOperationType.REDUCE, Stream.class, Optional.class, stream -> stream.reduce(accumulator), accumulator);
    }

    public <T, U> TerminalOperation<Stream<T>, U> createReduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ApplyTerminalOperation<Stream, Object, Function<Stream, Object>>(TerminalOperationType.REDUCE, Stream.class, Object.class, stream -> stream.reduce(identity, accumulator, combiner), identity, accumulator, combiner);
    }

    public <T, R> TerminalOperation<Stream<T>, R> createCollect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ApplyTerminalOperation<Stream, Object, Function<Stream, Object>>(TerminalOperationType.COLLECT, Stream.class, Object.class, stream -> stream.collect(supplier, accumulator, combiner), supplier, accumulator, combiner);
    }

    public <T, R, A> TerminalOperation<Stream<T>, R> createCollect(Collector<? super T, A, R> collector) {
        Objects.requireNonNull(collector);
        return new ApplyTerminalOperation<Stream, Object, Function<Stream, Object>>(TerminalOperationType.COLLECT, Stream.class, Object.class, stream -> stream.collect(collector), collector);
    }

    public <T> TerminalOperation<Stream<T>, Optional<T>> createMin(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return new ApplyTerminalOperation<Stream, Optional, Function<Stream, Optional>>(TerminalOperationType.MIN, Stream.class, Optional.class, stream -> stream.min(comparator), comparator);
    }

    public <T> TerminalOperation<Stream<T>, Optional<T>> createMax(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return new ApplyTerminalOperation<Stream, Optional, Function<Stream, Optional>>(TerminalOperationType.MAX, Stream.class, Optional.class, stream -> stream.max(comparator), comparator);
    }

    public <T> TerminalOperation<Stream<T>, Long> acquireCount() {
        return this.typed(COUNT);
    }

    public <T> TerminalOperation<Stream<T>, Boolean> createAnyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<Stream, Boolean, Predicate<Stream>>(TerminalOperationType.ANY_MATCH, Stream.class, Boolean.TYPE, stream -> stream.anyMatch(predicate), predicate);
    }

    public <T> TerminalOperation<Stream<T>, Boolean> createAllMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<Stream, Boolean, Predicate<Stream>>(TerminalOperationType.ALL_MATCH, Stream.class, Boolean.TYPE, stream -> stream.allMatch(predicate), predicate);
    }

    public <T> TerminalOperation<Stream<T>, Boolean> createNoneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<Stream, Boolean, Predicate<Stream>>(TerminalOperationType.NONE_MATCH, Stream.class, Boolean.TYPE, stream -> stream.noneMatch(predicate), predicate);
    }

    public <T> TerminalOperation<Stream<T>, Optional<T>> acquireFindFirst() {
        return this.typed(FIND_FIRST);
    }

    public <T> TerminalOperation<Stream<T>, Optional<T>> acquireFindAny() {
        return this.typed(FIND_ANY);
    }

    public <T, S extends BaseStream<T, S>> TerminalOperation<S, Iterator<T>> acquireIterator() {
        return this.typed(ITERATOR);
    }

    public <T, S extends BaseStream<T, S>> TerminalOperation<S, Spliterator<T>> acquireSpliterator() {
        return this.typed(SPLITERATOR);
    }

    private <S extends BaseStream<?, S>, R> TerminalOperation<S, R> typed(TerminalOperation<?, ?> terminalOperation) {
        return terminalOperation;
    }
}

