/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.intermediate.standard.internal;

import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.pipeline.intermediate.LongIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.standard.internal.StandardIntermediateOperation;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalLongIntermediateOperationFactory
implements LongIntermediateOperationFactory {
    private static final Function<LongStream, LongStream> SORTED_FUNCTION = LongStream::sorted;
    private static final IntermediateOperation<LongStream, LongStream> SORTED = new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.SORTED, LongStream.class, LongStream.class, SORTED_FUNCTION, new Object[0]);
    private static final Function<LongStream, LongStream> DISTINCT_FUNCTION = LongStream::distinct;
    private static final IntermediateOperation<LongStream, LongStream> DISTINCT = new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.DISTINCT, LongStream.class, LongStream.class, DISTINCT_FUNCTION, new Object[0]);
    private static final Function<LongStream, Stream<Long>> BOXED_FUNCTION = LongStream::boxed;
    private static final IntermediateOperation<LongStream, Stream<Long>> BOXED = new StandardIntermediateOperation<LongStream, Stream<Long>>(IntermediateOperationType.BOXED, LongStream.class, Stream.class, BOXED_FUNCTION, new Object[0]);
    private static final Function<LongStream, DoubleStream> AS_DOUBLE_STREAM_FUNCTION = LongStream::asDoubleStream;
    private static final IntermediateOperation<LongStream, DoubleStream> AS_DOUBLE_STREAM = new StandardIntermediateOperation<LongStream, DoubleStream>(IntermediateOperationType.AS, LongStream.class, DoubleStream.class, AS_DOUBLE_STREAM_FUNCTION, new Object[0]);

    public IntermediateOperation<LongStream, LongStream> createFilter(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.filter(predicate);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.FILTER, LongStream.class, LongStream.class, function, predicate);
    }

    public IntermediateOperation<LongStream, LongStream> createMap(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.map(mapper);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.MAP_TO_SAME, LongStream.class, LongStream.class, function, mapper);
    }

    public <U> IntermediateOperation<LongStream, Stream<U>> createMapToObj(LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        Function<LongStream, Stream> function = s -> s.mapToObj(mapper);
        return new StandardIntermediateOperation<LongStream, Stream<U>>(IntermediateOperationType.MAP_TO, LongStream.class, Stream.class, function, mapper);
    }

    public IntermediateOperation<LongStream, IntStream> createMapToInt(LongToIntFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<LongStream, IntStream> function = s -> s.mapToInt(mapper);
        return new StandardIntermediateOperation<LongStream, IntStream>(IntermediateOperationType.MAP_TO, LongStream.class, IntStream.class, function, mapper);
    }

    public IntermediateOperation<LongStream, DoubleStream> createMapToDouble(LongToDoubleFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<LongStream, DoubleStream> function = s -> s.mapToDouble(mapper);
        return new StandardIntermediateOperation<LongStream, DoubleStream>(IntermediateOperationType.MAP_TO, LongStream.class, DoubleStream.class, function, mapper);
    }

    public IntermediateOperation<LongStream, LongStream> createFlatMap(LongFunction<? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.flatMap(mapper);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.FLAT_MAP_TO_SAME, LongStream.class, LongStream.class, function, mapper);
    }

    public IntermediateOperation<LongStream, LongStream> acquireDistinct() {
        return DISTINCT;
    }

    public IntermediateOperation<LongStream, LongStream> acquireSorted() {
        return SORTED;
    }

    public IntermediateOperation<LongStream, LongStream> createPeek(LongConsumer action) {
        Objects.requireNonNull(action);
        UnaryOperator function = s -> s.peek(action);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.PEEK, LongStream.class, LongStream.class, function, action);
    }

    public IntermediateOperation<LongStream, LongStream> createLimit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        UnaryOperator function = s -> s.limit(maxSize);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.LIMIT, LongStream.class, LongStream.class, function, maxSize);
    }

    public IntermediateOperation<LongStream, LongStream> createSkip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        UnaryOperator function = s -> s.skip(n);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.SKIP, LongStream.class, LongStream.class, function, n);
    }

    public IntermediateOperation<LongStream, LongStream> createTakeWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.takeWhile(predicate);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.TAKE_WHILE, LongStream.class, LongStream.class, function, predicate);
    }

    public IntermediateOperation<LongStream, LongStream> createDropWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.dropWhile(predicate);
        return new StandardIntermediateOperation<LongStream, LongStream>(IntermediateOperationType.DROP_WHILE, LongStream.class, LongStream.class, function, predicate);
    }

    public IntermediateOperation<LongStream, Stream<Long>> acquireBoxed() {
        return BOXED;
    }

    public IntermediateOperation<LongStream, DoubleStream> acquireAsDoubleStream() {
        return AS_DOUBLE_STREAM;
    }
}

