/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.chars;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasCharValue;
import java.util.Objects;

public final class CharNotBetweenPredicate<ENTITY>
extends AbstractFieldPredicate<ENTITY, HasCharValue<ENTITY>>
implements HasInclusion,
HasArg0<Character>,
HasArg1<Character> {
    private final char start;
    private final char end;
    private final Inclusion inclusion;

    public CharNotBetweenPredicate(HasCharValue<ENTITY> field, char start, char end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            char fieldValue = field.getAsChar(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + inclusion);
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Character get0() {
        return Character.valueOf(this.start);
    }

    @Override
    public Character get1() {
        return Character.valueOf(this.end);
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public CharBetweenPredicate<ENTITY> negate() {
        return new CharBetweenPredicate((HasCharValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

