/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.comparator;

import com.speedment.common.invariant.NullUtil;
import com.speedment.jpastreamer.field.comparator.DoubleFieldComparator;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.AbstractFieldComparator;
import com.speedment.jpastreamer.field.trait.HasDoubleValue;
import java.util.Objects;

public final class DoubleFieldComparatorImpl<ENTITY>
extends AbstractFieldComparator<ENTITY>
implements DoubleFieldComparator<ENTITY> {
    private final HasDoubleValue<ENTITY> field;
    private final boolean reversed;

    public DoubleFieldComparatorImpl(HasDoubleValue<ENTITY> field) {
        this(field, false);
    }

    DoubleFieldComparatorImpl(HasDoubleValue<ENTITY> field, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.reversed = reversed;
    }

    @Override
    public HasDoubleValue<ENTITY> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.NONE;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public DoubleFieldComparatorImpl<ENTITY> reversed() {
        return new DoubleFieldComparatorImpl<ENTITY>(this.field, !this.reversed);
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        NullUtil.requireNonNulls(first, second);
        double a = this.field.getAsDouble(first);
        double b = this.field.getAsDouble(second);
        return this.applyReversed(Double.compare(a, b));
    }

    public int hashCode() {
        return (4049 + Objects.hashCode(this.field.table())) * 3109 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && Objects.equals(this.field.table(), casted.getField().table());
    }

    public String toString() {
        return "(order by " + this.field.table() + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int applyReversed(double compare) {
        if (compare == 0.0) {
            return 0;
        }
        if (this.reversed) {
            if (compare > 0.0) {
                return -1;
            }
            return 1;
        }
        if (compare > 0.0) {
            return 1;
        }
        return -1;
    }
}

