/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.criteria.standard.internal;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.OrderFactory;
import com.speedment.jpastreamer.criteria.standard.internal.order.OrderMapper;
import com.speedment.jpastreamer.exception.JPAStreamerException;
import com.speedment.jpastreamer.field.comparator.CombinedComparator;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import jakarta.persistence.criteria.Order;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class InternalOrderFactory
implements OrderFactory {
    private final OrderMapper orderMapper = OrderMapper.createOrderMapper();

    public <ENTITY> List<Order> createOrder(Criteria<ENTITY, ?> criteria, Comparator<ENTITY> comparator) {
        Objects.requireNonNull(criteria);
        Objects.requireNonNull(comparator);
        if (comparator instanceof FieldComparator) {
            FieldComparator fieldComparator2 = (FieldComparator)comparator;
            return Collections.singletonList(this.orderMapper.mapOrder(criteria, fieldComparator2));
        }
        if (comparator instanceof CombinedComparator) {
            CombinedComparator combinedComparator = (CombinedComparator)comparator;
            return combinedComparator.stream().map(fieldComparator -> this.orderMapper.mapOrder(criteria, fieldComparator)).collect(Collectors.toList());
        }
        throw new JPAStreamerException("Comparator type [" + comparator.getClass().getSimpleName() + "] is not supported");
    }
}

