/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.singletonstream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class SingletonStream<T>
implements Stream<T> {
    private final T element;

    private SingletonStream(T element) {
        this.element = element;
    }

    public static <T> SingletonStream<T> of(T element) {
        return new SingletonStream<T>(element);
    }

    public static <T> Stream<T> ofNullable(T element) {
        return element == null ? SingletonStream.empty() : SingletonStream.of(element);
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.toStream().filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMapToDouble(mapper);
    }

    @Override
    public SingletonStream<T> distinct() {
        return this;
    }

    @Override
    public SingletonStream<T> sorted() {
        return this;
    }

    @Override
    public SingletonStream<T> sorted(Comparator<? super T> comparator) {
        return this;
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.toStream().peek(action);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        if (maxSize == 0L) {
            return SingletonStream.empty();
        }
        if (maxSize > 0L) {
            return this;
        }
        throw new IllegalArgumentException(Long.toString(maxSize));
    }

    @Override
    public Stream<T> skip(long n) {
        if (n == 0L) {
            return this;
        }
        if (n > 0L) {
            return SingletonStream.empty();
        }
        throw new IllegalArgumentException(Long.toString(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        Objects.requireNonNull(generator);
        A[] result = generator.apply(1);
        result[0] = this.element;
        return result;
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return (T)accumulator.apply(identity, this.element);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.toOptional();
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Objects.requireNonNull(accumulator);
        return accumulator.apply(identity, this.element);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        R value = supplier.get();
        accumulator.accept(value, this.element);
        return value;
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        Objects.requireNonNull(collector);
        A value = collector.supplier().get();
        collector.accumulator().accept(value, this.element);
        return collector.finisher().apply(value);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.toOptional();
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.toOptional();
    }

    @Override
    public long count() {
        return 1L;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return !predicate.test(this.element);
    }

    @Override
    public Optional<T> findFirst() {
        return this.toOptional();
    }

    @Override
    public Optional<T> findAny() {
        return this.toOptional();
    }

    @Override
    public Iterator<T> iterator() {
        return SingletonStream.singletonIterator(this.element);
    }

    @Override
    public Spliterator<T> spliterator() {
        return SingletonStream.singletonSpliterator(this.element);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public SingletonStream<T> sequential() {
        return this;
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.toStream().parallel();
    }

    @Override
    public Stream<T> unordered() {
        return this;
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.toStream().onClose(closeHandler);
    }

    @Override
    public void close() {
    }

    private Stream<T> toStream() {
        return Stream.of(this.element);
    }

    private Optional<T> toOptional() {
        return Optional.of(this.element);
    }

    private static <T> Stream<T> empty() {
        return Stream.empty();
    }

    public static <E> Iterator<E> singletonIterator(final E e) {
        return new Iterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    action.accept(e);
                    this.hasNext = false;
                }
            }
        };
    }

    private static <T> Spliterator<T> singletonSpliterator(final T element) {
        return new Spliterator<T>(){
            long estimatedSize = 1L;

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                if (this.estimatedSize > 0L) {
                    --this.estimatedSize;
                    consumer.accept(element);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.estimatedSize;
            }

            @Override
            public int characteristics() {
                int value = element != null ? 256 : 0;
                return value | 0x40 | 0x4000 | 0x400 | 1 | 0x10;
            }
        };
    }

    @Override
    public Stream<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return this;
        }
        return SingletonStream.empty();
    }

    @Override
    public Stream<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return SingletonStream.empty();
        }
        return this;
    }
}

