/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.singletonstream;

import com.speedment.common.singletonstream.internal.SingletonUtil;
import java.util.LongSummaryStatistics;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class SingletonLongStream
implements LongStream {
    private final long element;

    private SingletonLongStream(long element) {
        this.element = element;
    }

    public static LongStream of(long element) {
        return new SingletonLongStream(element);
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.toStream().filter(predicate);
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().map(mapper);
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToObj(mapper);
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToInt(mapper);
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToDouble(mapper);
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMap(mapper);
    }

    @Override
    public LongStream distinct() {
        return this;
    }

    @Override
    public LongStream sorted() {
        return this;
    }

    @Override
    public LongStream peek(LongConsumer action) {
        Objects.requireNonNull(action);
        return this.toStream().peek(action);
    }

    @Override
    public LongStream limit(long maxSize) {
        if (maxSize == 0L) {
            return SingletonLongStream.empty();
        }
        if (maxSize > 0L) {
            return this;
        }
        throw new IllegalArgumentException(Long.toString(maxSize));
    }

    @Override
    public LongStream skip(long n) {
        if (n == 0L) {
            return this;
        }
        if (n > 0L) {
            return SingletonLongStream.empty();
        }
        throw new IllegalArgumentException(Long.toString(n));
    }

    @Override
    public void forEach(LongConsumer action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public long[] toArray() {
        long[] result = new long[]{this.element};
        return result;
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        return op.applyAsLong(identity, this.element);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        return this.toOptional();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        R value = supplier.get();
        accumulator.accept(value, this.element);
        return value;
    }

    @Override
    public long sum() {
        return this.element;
    }

    @Override
    public OptionalLong min() {
        return this.toOptional();
    }

    @Override
    public OptionalLong max() {
        return this.toOptional();
    }

    @Override
    public long count() {
        return 1L;
    }

    @Override
    public OptionalDouble average() {
        return OptionalDouble.of(this.element);
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        LongSummaryStatistics result = new LongSummaryStatistics();
        result.accept(this.element);
        return result;
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return !predicate.test(this.element);
    }

    @Override
    public OptionalLong findFirst() {
        return this.toOptional();
    }

    @Override
    public OptionalLong findAny() {
        return this.toOptional();
    }

    @Override
    public DoubleStream asDoubleStream() {
        return DoubleStream.of((double)this.element);
    }

    @Override
    public Stream<Long> boxed() {
        return this.mapToObj(Long::valueOf);
    }

    @Override
    public LongStream sequential() {
        return this;
    }

    @Override
    public LongStream parallel() {
        return this.toStream().parallel();
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return SingletonLongStream.singletonLongIterator(this.element);
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return SingletonLongStream.singletonLongSpliterator(this.element);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public LongStream unordered() {
        return this;
    }

    @Override
    public LongStream onClose(Runnable closeHandler) {
        return (LongStream)this.toStream().onClose(closeHandler);
    }

    @Override
    public void close() {
    }

    private LongStream toStream() {
        return LongStream.of(this.element);
    }

    private OptionalLong toOptional() {
        return OptionalLong.of(this.element);
    }

    private static LongStream empty() {
        return LongStream.empty();
    }

    private static PrimitiveIterator.OfLong singletonLongIterator(final long e) {
        return new PrimitiveIterator.OfLong(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long nextLong() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public Long next() {
                if (SingletonUtil.TRIPWIRE_ENABLED) {
                    SingletonUtil.trip(this.getClass(), "{0} calling SingletonLongStream.singletonIterator.next()");
                }
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                return this.nextLong();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    action.accept(e);
                    this.hasNext = false;
                }
            }
        };
    }

    private static Spliterator.OfLong singletonLongSpliterator(final long element) {
        return new Spliterator.OfLong(){
            long estimatedSize = 1L;

            @Override
            public Spliterator.OfLong trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(LongConsumer consumer) {
                Objects.requireNonNull(consumer);
                if (this.estimatedSize > 0L) {
                    --this.estimatedSize;
                    consumer.accept(element);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(LongConsumer consumer) {
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.estimatedSize;
            }

            @Override
            public int characteristics() {
                return 17745;
            }
        };
    }

    @Override
    public LongStream takeWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return this;
        }
        return SingletonLongStream.empty();
    }

    @Override
    public LongStream dropWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return SingletonLongStream.empty();
        }
        return this;
    }
}

