/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.singletonstream;

import com.speedment.common.singletonstream.internal.SingletonUtil;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class SingletonIntStream
implements IntStream {
    private final int element;

    private SingletonIntStream(int element) {
        this.element = element;
    }

    public static IntStream of(int element) {
        return new SingletonIntStream(element);
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.toStream().filter(predicate);
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().map(mapper);
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToObj(mapper);
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().mapToDouble(mapper);
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return this.toStream().flatMap(mapper);
    }

    @Override
    public IntStream distinct() {
        return this;
    }

    @Override
    public IntStream sorted() {
        return this;
    }

    @Override
    public IntStream peek(IntConsumer action) {
        Objects.requireNonNull(action);
        return this.toStream().peek(action);
    }

    @Override
    public IntStream limit(long maxSize) {
        if (maxSize == 0L) {
            return SingletonIntStream.empty();
        }
        if (maxSize > 0L) {
            return this;
        }
        throw new IllegalArgumentException(Long.toString(maxSize));
    }

    @Override
    public IntStream skip(long n) {
        if (n == 0L) {
            return this;
        }
        if (n > 0L) {
            return SingletonIntStream.empty();
        }
        throw new IllegalArgumentException(Long.toString(n));
    }

    @Override
    public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        Objects.requireNonNull(action);
        action.accept(this.element);
    }

    @Override
    public int[] toArray() {
        int[] result = new int[]{this.element};
        return result;
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        return op.applyAsInt(identity, this.element);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        return this.toOptional();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        R value = supplier.get();
        accumulator.accept(value, this.element);
        return value;
    }

    @Override
    public int sum() {
        return this.element;
    }

    @Override
    public OptionalInt min() {
        return this.toOptional();
    }

    @Override
    public OptionalInt max() {
        return this.toOptional();
    }

    @Override
    public long count() {
        return 1L;
    }

    @Override
    public OptionalDouble average() {
        return OptionalDouble.of(this.element);
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics result = new IntSummaryStatistics();
        result.accept(this.element);
        return result;
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return predicate.test(this.element);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return !predicate.test(this.element);
    }

    @Override
    public OptionalInt findFirst() {
        return this.toOptional();
    }

    @Override
    public OptionalInt findAny() {
        return this.toOptional();
    }

    @Override
    public LongStream asLongStream() {
        return LongStream.of((long)this.element);
    }

    @Override
    public DoubleStream asDoubleStream() {
        return DoubleStream.of((double)this.element);
    }

    @Override
    public Stream<Integer> boxed() {
        return this.mapToObj(Integer::valueOf);
    }

    @Override
    public IntStream sequential() {
        return this;
    }

    @Override
    public IntStream parallel() {
        return this.toStream().parallel();
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return SingletonIntStream.singletonIntIterator(this.element);
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return SingletonIntStream.singletonIntSpliterator(this.element);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public IntStream unordered() {
        return this;
    }

    @Override
    public IntStream onClose(Runnable closeHandler) {
        return (IntStream)this.toStream().onClose(closeHandler);
    }

    @Override
    public void close() {
    }

    private IntStream toStream() {
        return IntStream.of(this.element);
    }

    private OptionalInt toOptional() {
        return OptionalInt.of(this.element);
    }

    private static IntStream empty() {
        return IntStream.empty();
    }

    private static PrimitiveIterator.OfInt singletonIntIterator(final int e) {
        return new PrimitiveIterator.OfInt(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int nextInt() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public Integer next() {
                if (SingletonUtil.TRIPWIRE_ENABLED) {
                    SingletonUtil.trip(this.getClass(), "{0} calling SingletonIntStream.singletonIterator.next()");
                }
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                return this.nextInt();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    action.accept(e);
                    this.hasNext = false;
                }
            }
        };
    }

    private static Spliterator.OfInt singletonIntSpliterator(final int element) {
        return new Spliterator.OfInt(){
            long estimatedSize = 1L;

            @Override
            public Spliterator.OfInt trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(IntConsumer consumer) {
                Objects.requireNonNull(consumer);
                if (this.estimatedSize > 0L) {
                    --this.estimatedSize;
                    consumer.accept(element);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(IntConsumer consumer) {
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.estimatedSize;
            }

            @Override
            public int characteristics() {
                return 17745;
            }
        };
    }

    @Override
    public IntStream takeWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return this;
        }
        return SingletonIntStream.empty();
    }

    @Override
    public IntStream dropWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.element)) {
            return SingletonIntStream.empty();
        }
        return this;
    }
}

