/*
 * Decompiled with CFR 0.152.
 */
package spark.debug;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Iterables {
    public static <T> Iterable<T> filter(final Iterable<T> input, final Filter<T> filter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(input.iterator(), filter);
            }
        };
    }

    public static <T, S> Iterable<S> map(final Iterable<T> input, final Mapper<T, S> mapper) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                return new MapIterator(input.iterator(), mapper);
            }
        };
    }

    public static <T, S> List<S> mapList(List<T> input, Mapper<T, S> mapper) {
        ListIterator<T> iterator = input.listIterator();
        while (iterator.hasNext()) {
            iterator.set(mapper.map(iterator.next()));
        }
        return input;
    }

    public static <T, S> S reduce(Iterable<T> collection, S initialValue, Reducer<T, S> reducer) {
        S value = initialValue;
        for (T item : collection) {
            value = reducer.reduce(value, item);
        }
        return value;
    }

    public static <T> Optional<T> first(Iterable<T> collection, Filter<T> filter) {
        for (T item : collection) {
            if (!filter.matches(item)) continue;
            return Optional.of(item);
        }
        return Optional.absent();
    }

    public static <T> T first(Iterable<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            return item;
        }
        throw new IllegalArgumentException("Provided iterable was empty.");
    }

    private static final class MapIterator<T, S>
    implements Iterator<S> {
        private final Iterator<T> input;
        private final Mapper<T, S> mapper;

        public MapIterator(Iterator<T> input, Mapper<T, S> mapper) {
            this.input = input;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public S next() {
            return this.mapper.map(this.input.next());
        }
    }

    private static final class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<T> input;
        private final Filter<T> filter;
        private boolean hasNext = false;
        private T next = null;

        public FilterIterator(Iterator<T> input, Filter<T> filter) {
            this.input = input;
            this.filter = filter;
            this.advance();
        }

        private void advance() {
            while (this.input.hasNext()) {
                this.hasNext = true;
                this.next = this.input.next();
                if (this.filter.matches(this.next)) {
                    return;
                }
                this.next = null;
                this.hasNext = false;
            }
            this.next = null;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            T value = this.next;
            this.advance();
            return value;
        }
    }

    @FunctionalInterface
    public static interface Reducer<T, S> {
        public S reduce(S var1, T var2);
    }

    @FunctionalInterface
    public static interface Mapper<T, S> {
        public S map(T var1);
    }

    @FunctionalInterface
    public static interface Filter<T> {
        public boolean matches(T var1);
    }
}

