/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public final class Marker {
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final String id;
    private final URL imageURL;
    private final int offsetX;
    private final int offsetY;
    private SimpleObjectProperty<Coordinate> position = new SimpleObjectProperty();
    private SimpleBooleanProperty visible = new SimpleBooleanProperty(false);

    public static Marker createProvided(Provided provided) {
        if (null == provided) {
            throw new IllegalArgumentException();
        }
        return new Marker(Marker.class.getResource("/markers/" + provided.getFilename()), provided.getOffsetX(), provided.getOffsetY());
    }

    public Marker(URL imageURL) {
        this(imageURL, 0, 0);
    }

    public Marker(URL imageURL, int offsetX, int offsetY) {
        if (null == imageURL) {
            throw new IllegalArgumentException();
        }
        this.id = "marker-" + nextId.getAndIncrement();
        this.imageURL = imageURL;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public String getId() {
        return this.id;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker marker = (Marker)o;
        return this.id.equals(marker.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Marker{id='" + this.id + '\'' + ", imageURL=" + this.imageURL + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", position=" + this.getPosition() + ", visible=" + this.getVisible() + '}';
    }

    public Coordinate getPosition() {
        return (Coordinate)this.position.get();
    }

    public boolean getVisible() {
        return this.visible.get();
    }

    public SimpleObjectProperty<Coordinate> positionProperty() {
        return this.position;
    }

    public Marker setPosition(Coordinate position) {
        this.position.set((Object)position);
        return this;
    }

    public Marker setVisible(boolean visible) {
        this.visible.set(visible);
        return this;
    }

    public SimpleBooleanProperty visibleProperty() {
        return this.visible;
    }

    public static enum Provided {
        BLUE("blue_map_marker.png", -32, -64),
        GREEN("green_map_marker.png", -32, -64),
        ORANGE("orange_map_marker.png", -32, -64),
        RED("red_map_marker.png", -32, -64);

        private final String filename;
        private final int offsetX;
        private final int offsetY;

        private Provided(String filename, int offsetX, int offsetY) {
            this.filename = filename;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }
    }
}

