/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.CoordinateEvent;
import com.sothawo.mapjfx.Extent;
import com.sothawo.mapjfx.MapType;
import com.sothawo.mapjfx.Marker;
import com.sothawo.mapjfx.MarkerChangeListeners;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;

public final class MapView
extends Region {
    public static final int MIN_ZOOM = 0;
    public static final int MAX_ZOOM = 28;
    public static final int INITIAL_ZOOM = 14;
    private static final Logger logger = Logger.getLogger(MapView.class.getCanonicalName());
    private static final String MAPVIEW_HTML = "/mapview.html";
    private static final String URL_PROTOCOL_FILE = "file";
    private WebEngine webEngine;
    private boolean mapViewLoadedFromLocalFile = false;
    private final ReadOnlyBooleanWrapper initialized = new ReadOnlyBooleanWrapper(false);
    private SimpleObjectProperty<Coordinate> center;
    private SimpleDoubleProperty zoom;
    private SimpleIntegerProperty animationDuration;
    private final AtomicReference<Coordinate> lastCoordinateFromMap = new AtomicReference();
    private final AtomicReference<Double> lastZoomFromMap = new AtomicReference();
    private SimpleObjectProperty<MapType> mapType;
    private final Map<Marker, MarkerChangeListeners> markers = new HashMap<Marker, MarkerChangeListeners>();
    private final ConcurrentHashMap<URL, String> imgCache = new ConcurrentHashMap();

    public MapView() {
        this.initProperties();
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(Paint.valueOf((String)"#ccc"), null, null)}));
    }

    private void initProperties() {
        this.center = new SimpleObjectProperty();
        this.center.addListener((ChangeListener)new ChangeListener<Coordinate>(){

            public void changed(ObservableValue<? extends Coordinate> observable, Coordinate oldValue, Coordinate newValue) {
                if (newValue != MapView.this.lastCoordinateFromMap.get()) {
                    logger.finer(() -> "center changed from " + oldValue + " to " + newValue);
                    MapView.this.setCenterInMap();
                }
            }
        });
        this.zoom = new SimpleDoubleProperty(14.0);
        this.zoom.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != MapView.this.lastZoomFromMap.get()) {
                    logger.finer(() -> "zoom changed from " + oldValue + " to " + newValue);
                    MapView.this.setZoomInMap();
                }
            }
        });
        this.animationDuration = new SimpleIntegerProperty(0);
        this.mapType = new SimpleObjectProperty((Object)MapType.OSM);
        this.mapType.addListener((ChangeListener)new ChangeListener<MapType>(){

            public void changed(ObservableValue<? extends MapType> observable, MapType oldValue, MapType newValue) {
                logger.finer(() -> "map type changed from " + (Object)((Object)oldValue) + " to " + (Object)((Object)newValue));
                MapView.this.setMapTypeInMap();
            }
        });
    }

    private void setCenterInMap() {
        Coordinate actCenter = this.getCenter();
        if (this.getInitialized() && null != actCenter) {
            String script = String.format(Locale.US, "setCenter(%f,%f,%d)", actCenter.getLatitude(), actCenter.getLongitude(), this.animationDuration.get());
            logger.finer(() -> "setting center in OpenLayers map: " + script);
            this.webEngine.executeScript(script);
        }
    }

    public Coordinate getCenter() {
        return (Coordinate)this.center.get();
    }

    public boolean getInitialized() {
        return this.initialized.get();
    }

    private void setZoomInMap() {
        if (this.getInitialized()) {
            int zoomInt = (int)this.getZoom();
            String script = String.format(Locale.US, "setZoom(%d,%d)", zoomInt, this.animationDuration.get());
            logger.finer(() -> "setting zoom in OpenLayers map: " + script);
            this.webEngine.executeScript(script);
        }
    }

    public double getZoom() {
        return this.zoom.get();
    }

    private void setMapTypeInMap() {
        if (this.getInitialized()) {
            String script = "setMapType('" + this.getMapType().toString() + "')";
            logger.finer(() -> "setting map type in OpenLayers map: " + script);
            this.webEngine.executeScript(script);
        }
    }

    public boolean addMarker(Marker marker) {
        if (null == marker) {
            throw new IllegalArgumentException();
        }
        if (null != this.markers.get(marker)) {
            return false;
        }
        ChangeListener coordinateChangeListener = (observable, oldValue, newValue) -> {
            if (null == oldValue) {
                this.addMarkerInMap(marker);
            } else {
                this.moveMarkerInMap(marker);
            }
        };
        ChangeListener visibileChangeListener = (observable, oldValue, newValue) -> this.setMarkerVisibleInMap(marker);
        this.markers.put(marker, new MarkerChangeListeners((ChangeListener<Coordinate>)coordinateChangeListener, (ChangeListener<Boolean>)visibileChangeListener));
        marker.positionProperty().addListener(coordinateChangeListener);
        marker.visibleProperty().addListener(visibileChangeListener);
        if (marker.getVisible() && null != marker.getPosition()) {
            this.addMarkerInMap(marker);
        }
        logger.finer(() -> "added marker " + marker);
        return true;
    }

    private void moveMarkerInMap(Marker marker) {
        if (this.getInitialized()) {
            String script = String.format(Locale.US, "moveMarker('%s',%f,%f)", marker.getId(), marker.getPosition().getLatitude(), marker.getPosition().getLongitude());
            logger.finer(() -> "move marker in OpenLayers map " + script);
            this.webEngine.executeScript(script);
        }
    }

    private void setMarkerVisibleInMap(Marker marker) {
        if (this.getInitialized()) {
            if (marker.getVisible()) {
                this.addMarkerInMap(marker);
            } else {
                this.removeMarkerInMap(marker);
            }
        }
    }

    private void removeMarkerInMap(Marker marker) {
        if (this.getInitialized()) {
            String script = String.format(Locale.US, "removeMarker('%s')", marker.getId());
            logger.finer(() -> "remove marker in OpenLayers map " + script);
            this.webEngine.executeScript(script);
        }
    }

    private void addMarkerInMap(Marker marker) {
        if (this.getInitialized() && null != marker.getPosition()) {
            String url = marker.getImageURL().toExternalForm();
            if (!this.mapViewLoadedFromLocalFile && URL_PROTOCOL_FILE.equals(marker.getImageURL().getProtocol())) {
                url = this.createDataURI(marker.getImageURL());
            }
            if (null != url) {
                String script = String.format(Locale.US, "addMarkerWithURL('%s','%s',%f,%f,%d,%d)", marker.getId(), url, marker.getPosition().getLatitude(), marker.getPosition().getLongitude(), marker.getOffsetX(), marker.getOffsetY());
                logger.finer(() -> "add marker in OpenLayers map " + script);
                this.webEngine.executeScript(script);
            }
        }
    }

    private String createDataURI(URL imageURL) {
        return this.imgCache.computeIfAbsent(imageURL, url -> {
            String dataUrl = null;
            try (InputStream isGuess = url.openStream();
                 InputStream isConvert = url.openStream();
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                String contentType = URLConnection.guessContentTypeFromStream(isGuess);
                if (null != contentType) {
                    int bytesRead;
                    byte[] chunk = new byte[4096];
                    while ((bytesRead = isConvert.read(chunk)) > 0) {
                        os.write(chunk, 0, bytesRead);
                    }
                    os.flush();
                    dataUrl = "data:" + contentType + ";base64," + Base64.getEncoder().encodeToString(os.toByteArray());
                } else {
                    logger.warning(() -> "could not get content type from " + imageURL.toExternalForm());
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "error loading image", e);
            }
            if (null == dataUrl) {
                logger.warning(() -> "could not create data url from " + imageURL.toExternalForm());
            }
            return dataUrl;
        });
    }

    public SimpleIntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public SimpleObjectProperty<Coordinate> centerProperty() {
        return this.center;
    }

    public int getAnimationDuration() {
        return this.animationDuration.get();
    }

    public MapType getMapType() {
        return (MapType)((Object)this.mapType.get());
    }

    public void initialize() {
        logger.finer("initializing...");
        WebView webView = new WebView();
        this.webEngine = webView.getEngine();
        webView.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        webView.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        webView.setContextMenuEnabled(false);
        this.getChildren().add((Object)webView);
        URL mapviewUrl = ((Object)((Object)this)).getClass().getResource(MAPVIEW_HTML);
        if (null == mapviewUrl) {
            logger.severe(() -> "resource not found: /mapview.html");
        } else {
            this.mapViewLoadedFromLocalFile = URL_PROTOCOL_FILE.equals(mapviewUrl.getProtocol());
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                    logger.finer(() -> "WebEngine loader state " + oldValue + " -> " + newValue);
                    if (Worker.State.SUCCEEDED == newValue) {
                        ((JSObject)MapView.this.webEngine.executeScript("window")).setMember("app", new JSConnector());
                        MapView.this.initialized.set(true);
                        MapView.this.setCenterInMap();
                        MapView.this.setZoomInMap();
                        logger.finer("initialized.");
                    } else if (Worker.State.FAILED == newValue) {
                        logger.severe(() -> "error loading /mapview.html");
                    }
                }
            });
            logger.finer(() -> "loading from " + mapviewUrl.toExternalForm());
            this.webEngine.load(mapviewUrl.toExternalForm());
        }
    }

    public ReadOnlyBooleanProperty initializedProperty() {
        return this.initialized.getReadOnlyProperty();
    }

    public SimpleObjectProperty<MapType> mapTypeProperty() {
        return this.mapType;
    }

    public void removeMarker(Marker marker) {
        if (null == marker) {
            throw new IllegalArgumentException();
        }
        if (this.markers.containsKey(marker)) {
            marker.positionProperty().removeListener(this.markers.get(marker).getCoordinateChangeListener());
            marker.visibleProperty().removeListener(this.markers.get(marker).getVisibileChangeListener());
            this.markers.remove(marker);
            this.removeMarkerInMap(marker);
            marker.setVisible(false);
            logger.finer(() -> "removed marker " + marker);
        }
    }

    public MapView setAnimationDuration(int animationDuration) {
        this.animationDuration.set(animationDuration);
        return this;
    }

    public MapView setCenter(Coordinate center) {
        this.center.set((Object)center);
        return this;
    }

    public MapView setExtent(Extent extent) {
        if (this.getInitialized() && null != extent) {
            String script = String.format(Locale.US, "setExtent(%f,%f,%f,%f,%d)", extent.getMin().getLatitude(), extent.getMin().getLongitude(), extent.getMax().getLatitude(), extent.getMax().getLongitude(), this.animationDuration.get());
            logger.finer(() -> "setting extent in OpenLayers map: " + script);
            this.webEngine.executeScript(script);
        }
        return this;
    }

    public MapView setMapType(MapType mapType) {
        this.mapType.set((Object)mapType);
        return this;
    }

    public MapView setZoom(double zoom) {
        double rounded = Math.round(zoom);
        if (rounded < 0.0 || rounded > 28.0) {
            return this;
        }
        this.zoom.set(rounded);
        return this;
    }

    public SimpleDoubleProperty zoomProperty() {
        return this.zoom;
    }

    public class JSConnector {
        public void centerMovedTo(String lat, String lon) {
            if (null == lat || null == lon) {
                return;
            }
            try {
                logger.finer(() -> "JS reports new center value " + lat + '/' + lon);
                Coordinate newCenter = new Coordinate(Double.valueOf(lat), Double.valueOf(lon));
                MapView.this.lastCoordinateFromMap.set(newCenter);
                MapView.this.setCenter(newCenter);
            }
            catch (NumberFormatException e) {
                logger.warning(() -> "illegal coordinate strings " + lat + '/' + lon);
            }
        }

        public void debug(String msg) {
            logger.finer(() -> "JS: " + msg);
        }

        public void singleClickAt(String lat, String lon) {
            if (null == lat || null == lon) {
                return;
            }
            try {
                logger.finer(() -> "JS reports single click at " + lat + '/' + lon);
                MapView.this.fireEvent(new CoordinateEvent(CoordinateEvent.MAP_CLICKED, new Coordinate(Double.valueOf(lat), Double.valueOf(lon))));
            }
            catch (NumberFormatException e) {
                logger.warning(() -> "illegal coordinate strings " + lat + '/' + lon);
            }
        }

        public void zoomChanged(String zoom) {
            if (null != zoom) {
                try {
                    logger.finer(() -> "JS reports zoom value " + zoom);
                    Double newZoom = Double.valueOf(zoom);
                    MapView.this.lastZoomFromMap.set(newZoom);
                    MapView.this.setZoom(newZoom);
                }
                catch (NumberFormatException e) {
                    logger.warning(() -> "illegal zoom string " + zoom);
                }
            }
        }

        public void showLink(String href) {
            if (!Desktop.isDesktopSupported()) {
                logger.warning(() -> "no desktop support for displaying " + href);
            } else {
                try {
                    Desktop.getDesktop().browse(new URI(href));
                }
                catch (IOException | URISyntaxException e) {
                    logger.log(Level.WARNING, "can't display " + href, e);
                }
            }
        }
    }
}

