/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import java.util.Arrays;
import java.util.Collection;

public final class Extent {
    private final Coordinate min;
    private final Coordinate max;

    public static Extent forCoordinates(Coordinate ... coordinates) {
        if (null == coordinates) {
            throw new IllegalArgumentException();
        }
        return Extent.forCoordinates(Arrays.asList(coordinates));
    }

    public static Extent forCoordinates(Collection<Coordinate> coordinates) {
        if (null == coordinates || coordinates.size() < 2) {
            throw new IllegalArgumentException();
        }
        double minLatitude = Double.MAX_VALUE;
        double maxLatitude = Double.MIN_VALUE;
        double minLongitude = Double.MAX_VALUE;
        double maxLongitude = Double.MIN_VALUE;
        for (Coordinate coordinate : coordinates) {
            minLatitude = Math.min(minLatitude, coordinate.getLatitude());
            maxLatitude = Math.max(maxLatitude, coordinate.getLatitude());
            minLongitude = Math.min(minLongitude, coordinate.getLongitude());
            maxLongitude = Math.max(maxLongitude, coordinate.getLongitude());
        }
        return new Extent(new Coordinate(minLatitude, minLongitude), new Coordinate(maxLatitude, maxLongitude));
    }

    public Extent(Coordinate min, Coordinate max) {
        if (null == min || null == max) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
    }

    public Coordinate getMax() {
        return this.max;
    }

    public Coordinate getMin() {
        return this.min;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extent extent = (Extent)o;
        return this.max.equals(extent.max) && this.min.equals(extent.min);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }
}

