/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.statistics.StatType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmfUhUtil {
    private static final Log Trace = LogFactory.getLog(SmfUhUtil.class);
    public static final int OK = 1;
    public static final int DROP = 2;

    public static final WireMessage validateUH(WireMessage msg, JCSMPSessionStats sessionStats) {
        SMFHeaderBean wmsg_header = msg.getSmfHeader();
        if (wmsg_header.isUnknownProtocol()) {
            int proto = wmsg_header.getProtocol();
            Trace.info((Object)String.format("Received message with unknown protocol %s (ignoring).", proto));
            sessionStats.incStat(StatType.SMF_DISCARDS_UNKNOWN_ELEMENT);
            return null;
        }
        int param_check = SmfUhUtil.testValidateUHParams(wmsg_header, sessionStats);
        switch (param_check) {
            case 1: {
                return msg;
            }
            case 2: {
                return null;
            }
        }
        return msg;
    }

    public static final int testValidateUHParams(HeaderDescriptionBean hdr, JCSMPSessionStats sessionStats) {
        if (hdr.isUnkParamFlagSet()) {
            switch (hdr.getMaxParamAction()) {
                case 0: {
                    Trace.debug((Object)"Ignored one or more unknown parameters in SMF header.");
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    Trace.info((Object)"Incoming SMF message has one or more unknown parameters in SMF header, ignoring.");
                    sessionStats.incStat(StatType.SMF_DISCARDS_UNKNOWN_ELEMENT);
                    return 2;
                }
            }
        }
        return 1;
    }
}

