/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import com.solacesystems.jcsmp.impl.compression.SolZlibDeflaterResult;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolZlibDeflater {
    private int compressionLevel;
    private static final Log Trace = LogFactory.getLog(SolZlibDeflater.class);

    public SolZlibDeflater(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setCompressionLevel(int newCompressionLevel) {
        this.compressionLevel = newCompressionLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SolZlibDeflaterResult deflate(byte[] uncompressedOutput, int compressedOutputLen) throws IOException, IllegalArgumentException {
        Deflater deflater;
        if (compressedOutputLen <= 0) {
            throw new IllegalArgumentException("the size of the compressed byte array must be greater than zero");
        }
        try {
            deflater = new Deflater(this.compressionLevel);
        }
        catch (GZIPException e) {
            throw new RuntimeException(e);
        }
        deflater.setInput(uncompressedOutput);
        byte[] compressedOutput = new byte[compressedOutputLen];
        deflater.setOutput(compressedOutput);
        int result = deflater.deflate(4);
        if (result == 1) {
            result = deflater.end();
            if (result == 0) return new SolZlibDeflaterResult(compressedOutput, deflater.total_out);
            throw new IOException("JZlib deflater.end() error, result: " + deflater.getMessage());
        }
        if (result != 0 && result != -5) throw new IOException("JZlib deflater.deflate() error, result: " + result);
        int numBufferGrows = 1;
        while (result == 0 || result == -5) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)("SolZlibDeflater - Growing output buffer since more space is required for compression. Growth " + numBufferGrows + ". Growing from " + compressedOutput.length + " to " + compressedOutput.length * 2));
            }
            compressedOutput = BufferUtil.growBuffer(compressedOutput, compressedOutput.length, compressedOutput.length * 2);
            deflater.setNextOut(compressedOutput);
            deflater.setAvailOut(compressedOutput.length - deflater.getNextOutIndex());
            result = deflater.deflate(4);
            ++numBufferGrows;
        }
        if (result != 1) throw new IOException("JZlib deflater.deflate() error, result: " + result + " numBufferGrows: " + numBufferGrows);
        result = deflater.end();
        if (result == 0) return new SolZlibDeflaterResult(compressedOutput, deflater.total_out);
        throw new IOException("JZlib deflater.end() error, message: " + deflater.getMessage());
    }
}

