/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.WireMessageEncoder;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import javax.transaction.xa.Xid;

public class XAWireMessageEncoder
implements WireMessageEncoder {
    static final int XaRecoverNumXids = XAWireMessageEncoder.getXaRecoverNumXids();
    private JCSMPBasicSession _session;
    private XASessionImpl _xaSession;
    private long _corrTag;
    private Xid _xid;
    private int _origFlags;
    private byte _flags;
    private int _transactionTimeout;
    private TransactionSteps _txSteps;
    private byte[] _scanCursor;
    private AssuredCtrlEnums.XACtrlMessageType _xaMsgType;

    private static int getXaRecoverNumXids() {
        int returnValue = 0;
        String propStr = System.getProperty("XA_RECOVER_NUM_XIDS");
        if (propStr != null) {
            try {
                returnValue = Integer.parseInt(propStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType xaMSgType, XASessionImpl xaSession, long corrTag, Xid xid, int origFlags, byte flags, int transactionTimeout, TransactionSteps txSteps, byte[] scanCursor) {
        switch (xaMSgType) {
            case CLOSE_XA_SESSION_REQUEST: 
            case OPEN_XA_SESSION_REQUEST: 
            case RESUME_XA_SESSION_REQUEST: 
            case CLOSE_XA_SESSION_RESPONSE: 
            case OPEN_XA_SESSION_RESPONSE: 
            case RESUME_XA_SESSION_RESPONSE: 
            case XA_RECOVER_RESPONSE: 
            case XA_RESPONSE: {
                throw new IllegalArgumentException(String.format("XA message type %s does not need an encoder", xaMSgType.toString()));
            }
        }
        this._xaMsgType = xaMSgType;
        this._session = xaSession.getXASessionManager().getJCSMPSession();
        this._xaSession = xaSession;
        this._corrTag = corrTag;
        this._xid = xid;
        this._origFlags = origFlags;
        this._flags = flags;
        this._transactionTimeout = transactionTimeout;
        this._txSteps = txSteps;
        this._scanCursor = scanCursor;
    }

    public AssuredCtrlEnums.XACtrlMessageType getXACtrlMessageType() {
        return this._xaMsgType;
    }

    public int getOrigFlags() {
        return this._origFlags;
    }

    public void setFlags(byte flags) {
        this._flags = flags;
    }

    @Override
    public WireMessage encode() {
        SMFHeaderBean smfHeader = null;
        WireMessage msgReq = null;
        AssuredCtrlHeaderBean assBean = null;
        switch (this._xaMsgType) {
            case XA_COMMIT_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                assBean = this._session.getAssuredCtrlFactory().createXACommit(this._xaSession.getTransactedSessionId(), this._flags, this._xid);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Commit");
                break;
            }
            case XA_END_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(19).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                long reqTransactedSessionId = this._xaSession.getTransactedSessionId();
                long recvTransactedSessionId = this._xaSession.getTransactedSessionId();
                if (this._xaSession.getParent() != null) {
                    recvTransactedSessionId = this._xaSession.getParent().getTransactedSessionId();
                }
                assBean = this._session.getAssuredCtrlFactory().createXAEnd(reqTransactedSessionId, recvTransactedSessionId, this._flags, this._xid, this._txSteps, this._xaSession.getMessageProducer());
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA End");
                break;
            }
            case XA_FORGET_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                assBean = this._session.getAssuredCtrlFactory().createXAForget(this._xaSession.getTransactedSessionId(), this._flags, this._xid);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Forget");
                break;
            }
            case XA_PREPARE_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                assBean = this._session.getAssuredCtrlFactory().createXAPrepare(this._xaSession.getTransactedSessionId(), this._flags, this._xid);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Prepare");
                break;
            }
            case XA_RECOVER_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                byte flags = 0;
                if (this._scanCursor != null) {
                    flags = 1;
                }
                assBean = this._session.getAssuredCtrlFactory().createXARecover(flags, XaRecoverNumXids, this._scanCursor);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Recover");
                break;
            }
            case XA_ROLLBACK_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                assBean = this._session.getAssuredCtrlFactory().createXARollback(this._xaSession.getTransactedSessionId(), this._flags, this._xid);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Rollback");
                break;
            }
            case XA_START_REQUEST: {
                smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(this._corrTag));
                smfHeader.setAdf(1);
                assBean = this._session.getAssuredCtrlFactory().createXAStart(this._xaSession.getTransactedSessionId(), this._transactionTimeout, this._flags, this._xid);
                msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                msgReq.setFriendlyName("ADCTRL-XA Start");
                break;
            }
            default: {
                throw new IllegalStateException("Cannot encode messages of type " + this._xaMsgType.toString());
            }
        }
        msgReq.encoder = this;
        return msgReq;
    }

    public long getCorrId() {
        return this._corrTag;
    }
}

