/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solace.transport.SocketLevelStats;
import com.solace.transport.SolTransport;
import com.solacesystems.jcsmp.JCSMPRuntime;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPStats;
import com.solacesystems.jcsmp.statistics.StatType;

public class JCSMPSessionStats
extends JCSMPStats {
    private JCSMPStats globalStats;
    private volatile boolean publishedAD;
    private final SocketLevelStats cachedSocketStats;

    public JCSMPSessionStats(JCSMPSession session) {
        super(session.getSessionName(), session);
        this.resetStats();
        this.globalStats = JCSMPRuntime.onlyInstance();
        this.publishedAD = false;
        this.cachedSocketStats = new SocketLevelStats();
    }

    public JCSMPSessionStats() {
        super("defaultname", null);
        this.resetStats();
        this.globalStats = JCSMPRuntime.onlyInstance();
        this.cachedSocketStats = new SocketLevelStats();
    }

    public SocketLevelStats getSocketStats() {
        return this.cachedSocketStats;
    }

    public void updateSocketStats(SolTransport adapter) {
        this.cachedSocketStats.setByteSent(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_BYTES_SENT)).setByteReceived(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_BYTES_RECVED)).setSSLByteSent(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_SENT)).setSSLByteReceived(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_RECVED)).setCompressedByteSent(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_SENT)).setCompressedByteReceived(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED)).setWebSocketByteSent(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_SENT)).setWebSocketByteReceived(adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED));
    }

    @Override
    public void incStat(StatType t) {
        super.incStat(t);
        this.globalStats.incStat(t);
    }

    @Override
    public void incStat(StatType t, long v) {
        super.incStat(t, v);
        this.globalStats.incStat(t, v);
    }

    public void setPublishedAD(boolean publishedAd) {
        this.publishedAD = publishedAd;
    }

    public boolean hasPublishedAD() {
        return this.publishedAD;
    }
}

