/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

import com.solace.transport.TransportCompressionConfiguration;
import com.solace.transport.TransportHttpProxyConfiguration;
import com.solace.transport.TransportSSLConfiguration;
import com.solace.transport.TransportSockProxyConfiguration;
import java.net.InetAddress;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TransportConfiguration {
    private String host;
    private int port;
    private boolean websocket = false;
    private int webSocketFrameSize = 65536;
    private Integer idleReadTimeout;
    private Integer idleWriteTimeout;
    private Boolean tcpNoDelay;
    private Integer connectTimeoutInMillis;
    private Boolean soBroadcast;
    private Boolean soKeepalive;
    private Boolean soReuseAddr;
    private Integer soSndBuf;
    private Integer soRcvBuf;
    private Integer soTimeout;
    private Integer soLinger;
    private Integer soBacklog;
    private boolean useDirectBuf;
    private InetAddress localAddress;
    private TransportSSLConfiguration sslConfig = null;
    private TransportCompressionConfiguration compressionConfig = null;
    private TransportHttpProxyConfiguration httpProxyConfig = null;
    private TransportSockProxyConfiguration sockProxyConfig = null;

    public TransportConfiguration(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public TransportConfiguration setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public TransportConfiguration setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isWebsocket() {
        return this.websocket;
    }

    public TransportConfiguration setWebsocket(boolean v) {
        this.websocket = v;
        return this;
    }

    public TransportConfiguration setWebsocketFrameSize(int sz) {
        this.webSocketFrameSize = sz;
        return this;
    }

    public int getWebsocketFrameSize() {
        return this.webSocketFrameSize;
    }

    public boolean isSecure() {
        return this.getSSLConfig() != null;
    }

    public Integer getIdleReadTimeout() {
        return this.idleReadTimeout;
    }

    public TransportConfiguration setIdleReadTimeout(Integer idleReadTimeout) {
        this.idleReadTimeout = idleReadTimeout;
        return this;
    }

    public Integer getIdleWriteTimeout() {
        return this.idleWriteTimeout;
    }

    public TransportConfiguration setIdleWriteTimeout(Integer idleWriteTimeout) {
        this.idleWriteTimeout = idleWriteTimeout;
        return this;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public TransportConfiguration setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public Integer getConnectTimeoutInMillis() {
        return this.connectTimeoutInMillis;
    }

    public TransportConfiguration setConnectTimeoutInMillis(Integer connectTimeoutInMillis) {
        this.connectTimeoutInMillis = connectTimeoutInMillis;
        return this;
    }

    public Boolean getSoBroadcast() {
        return this.soBroadcast;
    }

    public TransportConfiguration setSoBroadcast(Boolean soBroadcast) {
        this.soBroadcast = soBroadcast;
        return this;
    }

    public Boolean getSoKeepalive() {
        return this.soKeepalive;
    }

    public TransportConfiguration setSoKeepalive(Boolean soKeepalive) {
        this.soKeepalive = soKeepalive;
        return this;
    }

    public Boolean getSoReuseAddr() {
        return this.soReuseAddr;
    }

    public TransportConfiguration setSoReuseAddr(Boolean soReuseAddr) {
        this.soReuseAddr = soReuseAddr;
        return this;
    }

    public Integer getSoSndBuf() {
        return this.soSndBuf;
    }

    public TransportConfiguration setSoSndBuf(Integer soSndBuf) {
        this.soSndBuf = soSndBuf;
        return this;
    }

    public Integer getSoRcvBuf() {
        return this.soRcvBuf;
    }

    public TransportConfiguration setSoRcvBuf(Integer soRcvBuf) {
        this.soRcvBuf = soRcvBuf;
        return this;
    }

    public boolean getUseDirectBuf() {
        return this.useDirectBuf;
    }

    public TransportConfiguration setUseDirectBuf(boolean useDirectBuffer) {
        this.useDirectBuf = useDirectBuffer;
        return this;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public TransportConfiguration setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public Integer getSoLinger() {
        return this.soLinger;
    }

    public TransportConfiguration setSoLinger(Integer soLinger) {
        this.soLinger = soLinger;
        return this;
    }

    public Integer getSoBacklog() {
        return this.soBacklog;
    }

    public TransportConfiguration setSoBacklog(Integer soBacklog) {
        this.soBacklog = soBacklog;
        return this;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public TransportConfiguration setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public TransportConfiguration setSSLConfig(TransportSSLConfiguration config) {
        this.sslConfig = config;
        return this;
    }

    public TransportSSLConfiguration getSSLConfig() {
        return this.sslConfig;
    }

    public TransportConfiguration setCompressionConfig(TransportCompressionConfiguration config) {
        this.compressionConfig = config;
        return this;
    }

    public TransportCompressionConfiguration getCompressionConfig() {
        return this.compressionConfig;
    }

    public TransportConfiguration setHttpProxyConfig(TransportHttpProxyConfiguration config) {
        this.httpProxyConfig = config;
        return this;
    }

    public TransportHttpProxyConfiguration getHttpProxyConfig() {
        return this.httpProxyConfig;
    }

    public TransportConfiguration setSockProxyConfig(TransportSockProxyConfiguration config) {
        this.sockProxyConfig = config;
        return this;
    }

    public TransportSockProxyConfiguration getSockProxyConfig() {
        return this.sockProxyConfig;
    }

    public String toString() {
        return "TransportConfiguration{host='" + this.host + '\'' + ", port=" + this.port + ", secure=" + this.isSecure() + ", websocket=" + this.websocket + ", idleReadTimeout=" + this.idleReadTimeout + ", idleWriteTimeout=" + this.idleWriteTimeout + ", tcpNoDelay=" + this.tcpNoDelay + ", connectTimeoutInMillis=" + this.connectTimeoutInMillis + ", soBroadcast=" + this.soBroadcast + ", soKeepalive=" + this.soKeepalive + ", soReuseAddr=" + this.soReuseAddr + ", soSndBuf=" + this.soSndBuf + ", soRcvBuf=" + this.soRcvBuf + ", soTimeout=" + this.soTimeout + ", soLinger=" + this.soLinger + ", soBacklog=" + this.soBacklog + ", localAddress=" + this.localAddress + '}';
    }
}

