/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jms.impl.JCSMPExceptionKey;
import com.solacesystems.jms.impl.JMSExceptionValue;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import jakarta.jms.JMSException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPExceptionMapper {
    private static final Log log = LogFactory.getLog(JCSMPExceptionMapper.class);
    private HashMap<String, ArrayListMapper> mappings = new HashMap();

    public void put(JCSMPExceptionKey key, JMSExceptionValue value) {
        ArrayListMapper mapper = this.mappings.get(key.getJCSMPException().getName());
        if (mapper == null) {
            mapper = new ArrayListMapper();
            this.mappings.put(key.getJCSMPException().getName(), mapper);
        }
        mapper.put(key, value);
    }

    public JMSException get(String operation, Throwable t) {
        ArrayListMapper mapper;
        JCSMPTransportException transpEx;
        JMSException returnEx = null;
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        boolean skipMapper = false;
        if (t instanceof JCSMPTransportException && (transpEx = (JCSMPTransportException)t).getCause() != null && transpEx.getCause() instanceof JCSMPErrorResponseException) {
            JCSMPErrorResponseException respEx = (JCSMPErrorResponseException)transpEx.getCause();
            if (respEx.getSubcodeEx() == 55) {
                skipMapper = true;
                String message = SolJMSErrorMessages.getMessage(operation, "soljms.error.unknownflowname", t.getMessage());
                returnEx = new JMSException(message, "soljms.error.unknownflowname");
            } else if (respEx.getSubcodeEx() == 64) {
                skipMapper = true;
                String message = SolJMSErrorMessages.getMessage(operation, "soljms.error.unknowntransactedsessionname", t.getMessage());
                returnEx = new JMSException(message, "soljms.error.unknowntransactedsessionname");
            }
        }
        if (!skipMapper && (mapper = this.mappings.get(t.getClass().getName())) != null) {
            returnEx = mapper.get(operation, t);
        }
        if (returnEx == null) {
            if (t instanceof JCSMPException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unmapped JCSMPException", t);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Unmapped Throwable", t);
            }
            returnEx = new JMSException(SolJMSErrorMessages.getMessage(operation, "soljms.error.internal", t.getMessage()), "soljms.error.internal");
        }
        if (t instanceof Exception) {
            returnEx.setLinkedException((Exception)t);
        }
        returnEx.initCause(t);
        return returnEx;
    }

    public String toString() {
        return this.mappings.toString();
    }

    public class ArrayListMapper {
        private ArrayList<JCSMPExceptionKey> keys = new ArrayList();
        private ArrayList<JMSExceptionValue> values = new ArrayList();

        public void put(JCSMPExceptionKey key, JMSExceptionValue value) {
            this.keys.add(key);
            this.values.add(value);
        }

        public JMSException get(String operation, Throwable t) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.get(i).equals(operation, t)) continue;
                return this.values.get(i).newInstance(operation, t);
            }
            return null;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder();
            for (int i = 0; i < this.keys.size(); ++i) {
                if (i > 0) {
                    bldr.append(",");
                }
                bldr.append("[");
                bldr.append("{");
                bldr.append(this.keys.get(i));
                bldr.append("}");
                bldr.append(",");
                bldr.append("{");
                bldr.append(this.values.get(i));
                bldr.append("}");
                bldr.append("]");
            }
            return bldr.toString();
        }
    }
}

