/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.impl.BrowserImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolQueueBrowserEnumeration;
import com.solacesystems.jms.SolQueueBrowserIF;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.JMSException;
import jakarta.jms.TemporaryQueue;
import java.util.Enumeration;

public class SolQueueBrowser
implements SolQueueBrowserIF {
    private final LogWrapper log = new LogWrapper(SolQueueBrowser.class);
    protected static final String Component = "QueueBrowser";
    protected SolSessionIF mSession;
    private jakarta.jms.Queue mQueue;
    private String mMessageSelector;
    private JMSState mState;
    private SolQueueBrowserEnumeration mEnumeration;
    private Browser mBrowser;
    private int mTimeout;

    public SolQueueBrowser(SolSessionIF session, jakarta.jms.Queue queue, String messageSelector) throws JMSException {
        this.mSession = session;
        this.mQueue = queue;
        this.mMessageSelector = messageSelector;
        this.mState = JMSState.Started;
        this.mEnumeration = null;
        this.mTimeout = session.getProperties().getConnectionProperties().getPropertyBean().getBrowserTimeoutInMS();
        this.createJCSMPBrowser();
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueBrowser created.  Queue: " + (queue == null ? "null" : queue.getQueueName()) + "   messageSelector: " + messageSelector);
        }
    }

    protected String getLogContextInfo() {
        if (this.mBrowser != null && this.mBrowser instanceof BrowserImpl && ((BrowserImpl)this.mBrowser).getFlowReceiver() != null && ((BrowserImpl)this.mBrowser).getFlowReceiver() instanceof FlowHandleImpl) {
            return ((FlowHandleImpl)((BrowserImpl)this.mBrowser).getFlowReceiver()).getLogContextInfo();
        }
        return "";
    }

    @Override
    public int getTimeout() {
        return this.mTimeout;
    }

    @Override
    public void close() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("D close().");
        }
        this.mBrowser.close();
        this.mSession.remove(this);
        this.mState = JMSState.Closed;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving close().  SolQueueBrowser closed.");
        }
    }

    public Enumeration<?> getEnumeration() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (this.mEnumeration == null) {
            this.mEnumeration = new SolQueueBrowserEnumeration(this);
        }
        return this.mEnumeration;
    }

    public String getMessageSelector() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mMessageSelector;
    }

    public jakarta.jms.Queue getQueue() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mQueue;
    }

    @Override
    public Browser getJCSMPBrowser() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mBrowser;
    }

    private void createJCSMPBrowser() throws JMSException {
        if (this.mQueue instanceof TemporaryQueue && this.mSession.getProperties().getConnectionProperties().getPropertyBean().getDirectTransport().booleanValue()) {
            throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.browserdirectmismatch", null), "soljms.error.browserdirectmismatch");
        }
        BrowserProperties browserProps = new BrowserProperties();
        Queue jcsmpQueue = (Queue)((SolDestination)this.mQueue).getJCSMPDestination();
        browserProps.setEndpoint(jcsmpQueue);
        browserProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        if (this.mSession.getProperties().getConnectionProperties().getPropertyBean().isSetReceiveADWindowSize()) {
            browserProps.setTransportWindowSize(this.mSession.getProperties().getConnectionProperties().getPropertyBean().getReceiveADWindowSize());
        }
        if (this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            browserProps.setReconnectTries(this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            browserProps.setReconnectRetryIntervalInMsecs(this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        try {
            this.mBrowser = this.mSession.getProperties().getConnectionProperties().getJCSMPSession().createBrowser(browserProps);
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.queue.browser", e);
        }
    }
}

