/*
 * Decompiled with CFR 0.152.
 */
package com.solace.serdes;

import com.solace.serdes.Deserializer;
import com.solace.serdes.EncodingUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class StringDeserializer
implements Deserializer<String> {
    private Charset encoding = StandardCharsets.UTF_8;
    public static final String SOLACE_DESERIALIZER_STRING_ENCODING = "solace.deserializer.string.encoding";

    @Override
    public void configure(Map<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        Object encodingValue = properties.get(SOLACE_DESERIALIZER_STRING_ENCODING);
        if (encodingValue == null) {
            return;
        }
        this.encoding = EncodingUtil.getEncoding(encodingValue);
    }

    @Override
    public String deserialize(String destinationName, byte[] payload) {
        if (payload == null) {
            return null;
        }
        return new String(payload, this.encoding);
    }
}

