/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.weather.providers.openweather;

import com.snowplowanalytics.weather.providers.openweather.WeatherCache;
import com.twitter.util.SynchronizedLruMap;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import scala.math.BigDecimal;
import scala.package$;

public abstract class WeatherCache$class {
    public static WeatherCache.CacheKey eventToCacheKey(WeatherCache $this, int timestamp, WeatherCache.Position position) {
        int timeFrame = $this.getStartOfDay(timestamp);
        WeatherCache.Position roundPosition = new WeatherCache.Position($this.roundCoordinate(position.latitude()), $this.roundCoordinate(position.longitude()));
        return new WeatherCache.CacheKey(timeFrame, roundPosition);
    }

    public static int getStartOfDay(WeatherCache $this, int timestamp) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date((long)timestamp * 1000L));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return (int)(calendar.getTimeInMillis() / 1000L);
    }

    public static float roundCoordinate(WeatherCache $this, float coordinate) {
        return package$.MODULE$.BigDecimal().decimal((float)Math.round(coordinate * (float)$this.geoPrecision()) / (float)$this.geoPrecision()).setScale(1, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toFloat();
    }

    public static void $init$(WeatherCache $this) {
        $this.com$snowplowanalytics$weather$providers$openweather$WeatherCache$_setter_$cache_$eq(new SynchronizedLruMap($this.cacheSize()));
        if ($this.geoPrecision() < 1) {
            throw new IllegalArgumentException("OwmCacheClient geoPrecision must be greater than zero");
        }
    }
}

